% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mort.r
\name{mort}
\alias{mort}
\title{Compute an index of knowledge complexity of industries using the method of reflection}
\usage{
mort(mat, rca = FALSE, steps = 19)
}
\arguments{
\item{mat}{An incidence matrix with regions in rows and industries in columns}

\item{rca}{Logical; should the index of relative comparative advantage (RCA - also refered to as location quotient) first be computed? Defaults to FALSE (a binary matrix - 0/1 - is expected as an input), but can be set to TRUE if the index of relative comparative advantage first needs to be computed}

\item{steps}{Number of iteration steps. Defaults to 19, but can be set to 0 to give ubiquity (number of regions that have a RCA in a industry), to 1 to give  the average diversity of the regions that have a RCA in this industry, to 2 to give the average ubiquity of technologies developed in the same regions, or to any other number of steps < or = to 21. Note that above steps = 2 the index will be rescaled from 0 (minimum relative complexity) to 100 (maximum relative complexity).}
}
\value{
If `steps` is set to 0, the function returns a numeric vector representing the ubiquity (number of regions that have a relative comparative advantage) of industries. Otherwise, it returns a numeric vector representing the index of knowledge complexity of industries based on the specified number of iteration steps.
}
\description{
This function computes an index of knowledge complexity of industries using the method of reflection from regions - industries (incidence) matrices. The index has been developed by Hidalgo and Hausmann (2009) for country - product matrices and adapted by Balland and Rigby (2016) to city - technology matrices.
}
\examples{
## generate a region - industry matrix with full count
set.seed(31)
mat <- matrix(sample(0:10, 20, replace = TRUE), ncol = 4)
rownames(mat) <- c("R1", "R2", "R3", "R4", "R5")
colnames(mat) <- c("I1", "I2", "I3", "I4")

## run the function
mort(mat, rca = TRUE)
mort(mat, rca = TRUE, steps = 0)
mort(mat, rca = TRUE, steps = 1)
mort(mat, rca = TRUE, steps = 2)

## generate a region - industry matrix in which cells represent the presence/absence of a rca
set.seed(32)
mat <- matrix(sample(0:1, 20, replace = TRUE), ncol = 4)
rownames(mat) <- c("R1", "R2", "R3", "R4", "R5")
colnames(mat) <- c("I1", "I2", "I3", "I4")

## run the function
mort(mat)
mort(mat, steps = 0)
mort(mat, steps = 1)
mort(mat, steps = 2)

## generate the simple network of Hidalgo and Hausmann (2009) presented p.11 (Fig. S4)
countries <- c("C1", "C1", "C1", "C1", "C2", "C3", "C3", "C4")
products <- c("P1", "P2", "P3", "P4", "P2", "P3", "P4", "P4")
my_data <- data.frame(countries, products)
my_data$freq <- 1
mat <- get_matrix(my_data)

## run the function
mort(mat)
mort(mat, steps = 0)
mort(mat, steps = 1)
mort(mat, steps = 2)
}
\references{
Hidalgo, C. and Hausmann, R. (2009) The building blocks of economic complexity, \emph{Proceedings of the National Academy of Sciences} \strong{106}: 10570 - 10575. \cr
\cr
Balland, P.A. and Rigby, D. (2017) The Geography of Complex Knowledge, \emph{Economic Geography} \strong{93} (1): 1-23.
}
\seealso{
\code{\link{location_quotient}}, \code{\link{ubiquity}}, \code{\link{diversity}}, \code{\link{kci}}, \code{\link{tci}}, \code{\link{morc}}
}
\author{
Pierre-Alexandre Balland \email{p.balland@uu.nl}
}
\keyword{complexity}
