% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/growth_list.ind.r
\name{growth_list_ind}
\alias{growth_list_ind}
\title{Generate a data frame of industrial growth in regions from multiple regions - industries matrices (same matrix composition for the different periods)}
\usage{
growth_list_ind(...)
}
\arguments{
\item{...}{Incidence matrices with regions in rows and industries in columns (period ... - optional)}
}
\value{
A data frame of industrial growth in regions
}
\description{
This function generates a data frame of industrial growth in regions from multiple regions - industries matrices (same matrix composition for the different periods). In this function, the maximum number of periods is limited to 20.
}
\examples{
## generate a first region - industry matrix with full count (period 1)
set.seed(31)
mat1 <- matrix(sample(0:10, 20, replace = TRUE), ncol = 4)
rownames(mat1) <- c("R1", "R2", "R3", "R4", "R5")
colnames(mat1) <- c("I1", "I2", "I3", "I4")

## generate a second region - industry matrix with full count (period 2)
mat2 <- mat1
mat2[3, 1] <- 8

## run the function
growth_list_ind(mat1, mat2)

## generate a third region - industry matrix with full count (period 3)
mat3 <- mat2
mat3[5, 2] <- 1

## run the function
growth_list_ind(mat1, mat2, mat3)

## generate a fourth region - industry matrix with full count (period 4)
mat4 <- mat3
mat4[5, 4] <- 1

## run the function
growth_list_ind(mat1, mat2, mat3, mat4)
}
\references{
Boschma, R., Balland, P.A. and Kogler, D. (2015) Relatedness and Technological Change in Cities: The rise and fall of technological knowledge in U.S. metropolitan areas from 1981 to 2010, \emph{Industrial and Corporate Change} \strong{24} (1): 223-250 \cr
\cr
Boschma, R., Heimeriks, G. and Balland, P.A. (2014) Scientific Knowledge Dynamics and Relatedness in Bio-Tech Cities, \emph{Research Policy} \strong{43} (1): 107-114
}
\seealso{
\code{\link{growth_list}}, \code{\link{entry_list}}, \code{\link{exit_list}}
}
\author{
Pierre-Alexandre Balland \email{p.balland@uu.nl}
}
\keyword{growth}
