% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Figure.R
\name{figure_dia}
\alias{figure_dia}
\title{Plot Diagnostic Model Evaluation Figures}
\usage{
figure_dia(type, data, file = NULL)
}
\arguments{
\item{type}{String, specifies the type of plot to generate. Options are
"roc", "prc", or "matrix".}

\item{data}{A list object containing model evaluation results. It must include:
\itemize{
\item \code{sample_score}: A data frame with "label" (0/1) and "score" columns.
\item \code{evaluation_metrics}: A list with a "Final_Threshold" or "Final_Threshold" value.
}}

\item{file}{Optional. A string specifying the path to save the plot (e.g.,
"plot.png"). If \code{NULL} (the default), the plot object is returned instead of being saved.}
}
\value{
A ggplot object. If the \code{file} argument is provided, the plot is also
saved to the specified path.
}
\description{
Generates and returns a ggplot object for Receiver Operating
Characteristic (ROC) curves, Precision-Recall (PRC) curves, or confusion matrices.
}
\examples{
# Create example data for a diagnostic model
external_eval_example_dia <- list(
  sample_score = data.frame(
    ID = paste0("S", 1:100),
    label = sample(c(0, 1), 100, replace = TRUE),
    score = runif(100, 0, 1)
  ),
  evaluation_metrics = list(
    Final_Threshold = 0.53
  )
)

# Generate an ROC curve plot object
roc_plot <- figure_dia(type = "roc", data = external_eval_example_dia)
# To display the plot, simply run:
# print(roc_plot)

# Generate a PRC curve and save it to a temporary file
# tempfile() creates a safe, temporary path as required by CRAN
temp_prc_path <- tempfile(fileext = ".png")
figure_dia(type = "prc", data = external_eval_example_dia, file = temp_prc_path)

# Generate a Confusion Matrix plot
matrix_plot <- figure_dia(type = "matrix", data = external_eval_example_dia)

}
