% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/personnelExchange.R
\name{personnelExchange}
\alias{personnelExchange}
\alias{hamming}
\alias{scenicDifference}
\title{Measuring Personnel Exchange over Boundaries}
\usage{
hamming(drama, variant = c("Trilcke", "Hamming", "NormalizedHamming"))

scenicDifference(drama, norm = length(unique(drama$text$Speaker.figure_id)))
}
\arguments{
\item{drama}{The QDDrama Object}

\item{variant}{For \code{hamming()}, variants are "Trilcke" (default), "NormalizedHamming", and "Hamming"}

\item{norm}{For \code{scenicDifference()}, specifies the normalization constant}
}
\value{
A QDHamming object, which is a list of values, one for each scene change.
The values indicate the (potentially) normalized number of characters that are exchanged.
}
\description{
There are multiple ways to quantify the number of characters that are 
exchanged over a scene or act boundary.
}
\examples{
data(rksp.0)
dist_trilcke  <- hamming(rksp.0)
dist_hamming  <- hamming(rksp.0, variant = "Hamming")
dist_nhamming <- hamming(rksp.0, variant = "NormalizedHamming")
}
