% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/NormalESDFPerc.R
\name{NormalESDFPerc}
\alias{NormalESDFPerc}
\title{Percentiles of ES distribution function for normally distributed P/L data}
\usage{
NormalESDFPerc(...)
}
\arguments{
\item{...}{The input arguments contain either return data or else mean and
standard deviation data. Accordingly, number of input arguments is either 4 or 6. In case there 4 input arguments, the mean, standard deviation and number of samples is computed from return data. See examples for details.

returns Vector of daily geometric return data

mu Mean of daily geometric return data

sigma Standard deviation of daily geometric return data

n Sample size

perc Desired percentile

cl ES confidence level and must be a scalar

hp ES holding period and must be a a scalar}
}
\value{
Percentiles of ES distribution function
}
\description{
Estimates the percentiles of ES distribution for normally distributed P/L data, for specified confidence level and holding period using the theory of order statistics.
}
\examples{
# Estimates Percentiles of ES distribution
   data <- runif(5, min = 0, max = .2)
   NormalESDFPerc(returns = data, perc = .7, cl = .95, hp = 60)

   # Estimates Percentiles given mean, standard deviation and number of sambles of return data
   NormalESDFPerc(mu = .012, sigma = .03, n= 10, perc = .8, cl = .99, hp = 40)
}
\author{
Dinesh Acharya
}
\references{
Dowd, K. Measuring Market Risk, Wiley, 2007.
}

