% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/BoxCoxVaR.R
\name{BoxCoxVaR}
\alias{BoxCoxVaR}
\title{Estimates VaR with Box-Cox transformation}
\usage{
BoxCoxVaR(PandLdata, cl)
}
\arguments{
\item{PandLdata}{Daily Profit/Loss data}

\item{cl}{Confidence Level. It can be a scalar or a vector.}
}
\value{
Estimated Box-Cox VaR. Its dimension is same as that of cl
}
\description{
Function estimates the VaR of a portfolio assuming P and L data set transformed
using the BoxCox transformation to make it as near normal as possible, for
specified confidence level and holding period implied by data frequency.
}
\examples{
# Estimates Box-Cox VaR
   a<-rnorm(100)
   BoxCoxVaR(a,.95)
}
\author{
Dinesh Acharya
}
\references{
Dowd, K. Measuring Market Risk, Wiley, 2007.

Hamilton, S. A. and Taylor, M. G. A Comparision of the Box-Cox
transformation method and nonparametric methods for estimating quantiles
in clinical data with repeated measures. J. Statist. Comput. Simul., vol.
45, 1993, pp. 185 - 201.
}

