% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/NormalVaRDFPerc.R
\name{NormalVaRDFPerc}
\alias{NormalVaRDFPerc}
\title{Percentiles of VaR distribution function for normally distributed P/L}
\usage{
NormalVaRDFPerc(...)
}
\arguments{
\item{...}{The input arguments contain either return data or else mean and
standard deviation data. Accordingly, number of input arguments is either 4
or 6. In case there 4 input arguments, the mean, standard deviation and number of observations of
data are computed from returns data. See examples for details.

returns Vector of daily geometric return data

 mu Mean of daily geometric return data
 sigma Standard deviation of daily geometric return data

 n Sample size

 perc Desired percentile

 cl VaR confidence level and must be a scalar

 hp VaR holding period and must be a a scalar}
}
\value{
Percentiles of VaR distribution function and is scalar
}
\description{
Estimates the percentile of VaR distribution function for normally distributed P/L, using the theory of order statistics.
}
\examples{
# Estimates Percentiles of VaR distribution
   data <- runif(5, min = 0, max = .2)
   NormalVaRDFPerc(returns = data, perc = .7, cl = .95, hp = 60)

   # Estimates Percentiles of VaR distribution
   NormalVaRDFPerc(mu = .012, sigma = .03, n= 10, perc = .8, cl = .99, hp = 40)
}
\author{
Dinesh Acharya
}
\references{
Dowd, K. Measuring Market Risk, Wiley, 2007.
}

