% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cyclicShiftColR.R
\name{cyclicShiftColR}
\alias{cyclicShiftColR}
\title{Perform the cyclic shift procedure on the columns of a matrix}
\usage{
cyclicShiftColR(X, randomSeed = NULL)
}
\arguments{
\item{X}{a matrix or a data frame of copy number data. The rows and columns
of X correspond to genes and subjects, respectively.}

\item{randomSeed}{a random seed.  Default = NULL.}
}
\value{
a matrix Z whose dimensions are the same as X.  Each column of Z
is obtained by perform a cyclic shift of the corresponding column of X.
}
\description{
Perform the cyclic shift procedure on the columns of a matrix
}
\details{
Many algorithms for identifying recurrent DNA copy number alterations,
e.g., amplifications and deletions, assess statistical significance using
permutation-based null distributions.  Like many genomic data types, DNA copy
number data has an underlying spatial correlation structure.  Randomly permuting
the values within a given subject ignores this structure, and this can impact
type I error rates.  In contrast, cyclic permutation largely preserves the
local correlation structure.
}
\examples{
test = matrix(c(1:50), 10, 5)
cyclicShiftColR(test, randomSeed = NULL)

}
