% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildSignatureMatrixMAST.R
\name{buildSignatureMatrixMAST}
\alias{buildSignatureMatrixMAST}
\title{Signature Matrix Using MAST}
\usage{
buildSignatureMatrixMAST(
  scdata,
  id,
  path,
  diff.cutoff = 0.5,
  pval.cutoff = 0.01,
  f = 200
)
}
\arguments{
\item{scdata}{The data}

\item{id}{The identities of the genes}

\item{path}{The path to the file results}

\item{diff.cutoff}{This is automatically set to 0.5}

\item{pval.cutoff}{This is automatically set to 0.01}

\item{f}{The maximum number of genes (when creating the signature matrix,
need to reduce number of genes, between 50:f number of significant genes are
chosen). If not set, this number is automatically set to 200.}
}
\value{
Signature Matrix built using the MAST algorithm
}
\description{
This function builds a signature matrix using genes identified
by the DEAnalysisMAST() function.
}
\examples{
\donttest{

#dataSC
#url <- "https://github.com/sistia01/DWLS/raw/main/inst/extdata/dataSC.RData"
#dest <- "data/dataSC.RData"
#load(download.file(url, tempfile(data/dataSC.RData))
#load("dataSC.RData")
#SOLUTION
load(system.file("extdata", "dataSC.RData", package = "DWLS"))

#dataBulk
#url <- "https://github.com/sistia01/DWLS/raw/main/inst/extdata/dataBulk.RData"
#dest <- "data/dataBulk.RData"
#load(download.file(url, tempfile(dest)))
#load("data/dataBulk.RData")
load(system.file("extdata", "dataBulk.RData", package = "DWLS"))

#labels
#url <- "https://github.com/sistia01/DWLS/raw/main/inst/extdata/labels.RData"
#dest <- "data/labels.RData"
#download.file(url, dest)
#load("data/labels.RData")
load(system.file("extdata", "labels.RData", package = "DWLS"))

#data('trueLabels', package = "DWLS")
#url <- "https://github.com/sistia01/DWLS/raw/main/inst/extdata/trueLabels.RData"
#dest <- "data/trueLabels.RData"
#download.file(url, dest)
#load("data/trueLabels.RData")
load(system.file("extdata", "trueLabels.RData", package = "DWLS"))

labels<-trueLabels

#Change to real labels
newcat<-c("NonCycISC","CycISC","TA","Ent","PreEnt","Goblet","Paneth","Tuft",
"EE")
for (i in 1:length(newcat)){
  labels[which(labels==(i-1))]<-newcat[i]
  }

#Run on local w/ inst/extdata/results folder
#Signature <-
#buildSignatureMatrixMAST(
#dataSC,labels,"inst/extdata/results",diff.cutoff = 0.5,pval.cutoff = 0.01)
}
}
