% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DTS.R
\name{edts}
\alias{edts}
\title{Log-likelihood function for a discrete tempered stable distribution.}
\usage{
edts(pv, smpl, tf = "poisson-tweedie", zt = FALSE)
}
\arguments{
\item{pv}{A vector of parameters.}

\item{smpl}{A sample data to be used for estimation.}

\item{tf}{Tempering function. It can be one of the "discrete-stable", "discrete-truncated-stable",
"discrete-pRDTS", "poisson-tweedie", "exp-tempering", "beta-prime-tempering", "Pareto-tempering".}

\item{zt}{Logical. If True it calculates zero-truncated probabilities.}
}
\value{
A number. Negative of likelihood function.
}
\description{
Log-likelihood function for a discrete tempered stable distribution.
}
\examples{
pv <- c(0.5, 1, 1)
n <- 100
smpl <- rdts(n, 0.5, 1)
edts(pv, smpl)
}
\references{
M. Grabchak. Discrete tempered stable distributions. Methodology and Computing in Applied Probability, 24(3):1877-1890, 2021.
}
