% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DNAmixture.R
\name{DNAmixture}
\alias{DNAmixture}
\alias{print.DNAmixture}
\title{Create a DNA mixture model}
\usage{
DNAmixture(
  data,
  k,
  C,
  database,
  K = character(0),
  reference.profiles = NULL,
  dir = character(0),
  domainnamelist = NULL,
  load = FALSE,
  write = FALSE,
  dyes = NULL,
  triangulate = TRUE,
  compile = TRUE,
  compress = TRUE,
  use.order = TRUE
)

\method{print}{DNAmixture}(x, ...)
}
\arguments{
\item{data}{A list containing one \code{data.frame} for each DNA
mixture. Note, that in the special case of analysing just one
mixture, this still has to be specified as list(data). Each
dataset should contain variables \code{marker}, \code{allele}, and
\code{frequency}. Optionally, also a column for each reference
profile specified in \code{K}.}

\item{k}{Number of contributors.}

\item{C}{A list of thresholds, one for each mixture.}

\item{database}{A data.frame containing at least variables \code{marker}, \code{allele}, \code{frequency}.}

\item{K}{Names of reference profiles; these can be chosen freely,
but should match (possibly only a subset of) the names specified
by the reference profiles.}

\item{reference.profiles}{A data.frame containing allele counts for each reference profile, if not specified in \code{data}.}

\item{dir}{Location of network files if loading or saving the networks.}

\item{domainnamelist}{Names of marker-wise network files (without hkb-extension). Default is the set of markers.}

\item{load}{Read networks from disk?}

\item{write}{Save networks as hkb files?}

\item{dyes}{A list containing a list of dyes indexed by markers}

\item{triangulate}{Triangulate the networks? Default is to
triangulate the network using a good elimination order.}

\item{compile}{Compile the networks?}

\item{compress}{Compress the network? Defaults to \code{TRUE} and is
strongly recommended for models with a large number of
contributors.}

\item{use.order}{Should the default elimination order be used for triangulation?
Otherwise the "total.weight" heuristic for triangulation in Hugin is used.}

\item{x}{An object of class \code{DNAmixture}.}

\item{...}{not used.}
}
\value{
An object of class \code{DNAmixture}. This contains amongst other things
\item{markers}{The joint set of markers used for the mixtures specified.}
\item{domains}{For models involving unknown contributors,
a list containing one Bayesian network (\code{hugin.domain}) per marker;
see \code{\link{buildMixtureDomains}} for details on the networks}
\item{data}{A list containing for each marker the combined allele frequencies,
peak heights, and reference profiles as produced by \code{\link{DNAmixtureData}}.}
}
\description{
A model object for analysis of one or more DNA mixtures. For a
brief overview of the package functionality, see
in particular \code{\link{DNAmixtures}}.

\emph{IMPORTANT: This is the \pkg{DNAmixturesLite} package, which
is intended as a service to enable users to try \pkg{DNAmixtures}
without purchasing a commercial licence for Hugin. When at all
possible, we strongly recommend the use of \pkg{DNAmixtures}
rather than this lite-version. See
\url{https://dnamixtures.r-forge.r-project.org/} for details on
both packages.}

\emph{While the lite-version seeks to provide the full functionality of
\pkg{DNAmixtures}, note that computations are much less efficient
and that there are some differences in available functionality. Be
aware that the present documentation is copied from
\pkg{DNAmixtures} and thus may not accurately describe the
implementation of this lite-version.}
}
\details{
The names for known contributors can be chosen freely, whereas
unknown contributors are always termed \code{U1,U2, ...}.

We allow for stutter to an allele one repeat number shorter. The
range of alleles at a marker is defined by the union of alleles
specified though the peak heights, the reference profiles, and the
allele frequencies. Any alleles that are included, but not found
in the database, will be assigned frequency \code{NA}, and it is then up
to the user to decide on further actions. If a particular mixture
has no observations at a marker, the heights are set to \code{NA}, but if
the mixture has some peaks at that marker, then missing heights
are all set to 0. Note that we hereby cover the possibility that
mixtures are analysed with different kits, and so are observed at
different markers. We do not (readily) allow kits to have
different ranges of possible alleles at one marker.

If amelogenin is included in the analysis, the marker should be
named \code{"AMEL"} and an integer coding such as X=0, Y=1, where X is
assigned a lower number than Y, should be used. Note that in terms
of amelogenin, the allele frequencies have a slighly different
interpretation to that for other markers, in that they denote the
probability of having an \emph{additional} X or Y to the X that
all people have. Thus, a natural choice will be \eqn{p(X)=p(Y)=0.5},
denoting equal probability of a male or female contributor.
}
\examples{
data(MC15, MC18, USCaucasian)
DNAmixture(list(MC15, MC18), C = list(50,50), k = 3, K = c("K1", "K2"),
           database = USCaucasian)
DNAmixture(list(MC15, MC18), C = list(50,50), k = 3, K = c("K3", "K1", "K2"),
           database = USCaucasian)
}
