% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{Replm2}
\alias{Replm2}
\title{Run Regression Analysis for All Locations}
\usage{
Replm2(
  data,
  formula,
  location_var,
  response_distribution = "normal",
  family = NULL
)
}
\arguments{
\item{data}{The dataset to be analyzed.}

\item{formula}{The formula for the regression model.}

\item{location_var}{The variable indicating different locations (e.g., `REGCODE`).}

\item{response_distribution}{The distribution of the response variable ("normal" for normal distribution, "other" for other distributions).}

\item{family}{The family to be used for GLM if response_distribution is "other" (e.g., `binomial` for logistic regression).}
}
\value{
A dataframe containing the combined results for all locations.
}
\description{
This function runs a regression model for all unique locations within a dataset and combines the results.
}
\examples{
set.seed(123)
library(dplyr)
dummy_data <- data.frame(
  years_education = rnorm(100, 12, 3),    # Represents years of education
  gender_female = rbinom(100, 1, 0.5),    # 1 = Female, 0 = Male
  household_wealth = sample(1:5, 100, replace = TRUE),  # Wealth index from 1 to 5
  district_code = sample(1:10, 100, replace = TRUE) # Represents district codes
) \%>\% arrange(district_code)

# Define a simple regression formula
formula <- years_education ~ gender_female + household_wealth + household_wealth:gender_female

# Run the regression across all locations (districts)
results1 <- Replm2(dummy_data, formula, "district_code", "normal")
print(results1)
}
