% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DGEAR.R
\name{DGEAR}
\alias{DGEAR}
\title{Differential Gene Expression Analysis with R}
\usage{
DGEAR(dataframe, con1, con2, exp1, exp2, alpha, votting_cutoff)
}
\arguments{
\item{dataframe}{A matrix containing the gene expression data}

\item{con1}{Starting column of the control of the expression data}

\item{con2}{Ending column of the control of the expression data}

\item{exp1}{Starting column of the experiment of the expression data}

\item{exp2}{Ending column of the experiment of the expression data}

\item{alpha}{Value of significance level ranging from 0 to 1 (0.05 states 5 \% significance)(Default = 0.05).}

\item{votting_cutoff}{A numeric value serves as Majority voting (Default = 2)}
}
\value{
A matrix containing Differentially Expressed Genes(DEGs) detected
}
\description{
Main function which incorporates results from five statistical models and detects DEGs through majority voting.
}
\details{
To use this tool the necessary parameters are con1 = Control start column, con2 = Control end column, exp1 = Experiment start column, exp2 = Experiment end column, alpha = Value of significance level, voting_cutoff = Majority voting value (not more than 5, since there are 5 statistical methods which take part in the majority voting)
}
\examples{
library(DGEAR)
data("gene_exp_data")
DGEAR(dataframe = gene_exp_data, con1 = 1, con2 = 10,
  exp1 = 11, exp2 = 20, alpha = 0.05, votting_cutoff = 2)
}
