% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/similarityMatrix.R
\name{as.symmetricAdjacencyMatrix}
\alias{as.symmetricAdjacencyMatrix}
\title{convert to a symmetric adjacency matrix}
\usage{
as.symmetricAdjacencyMatrix(Data, weighted = FALSE, rule = "weak")
}
\arguments{
\item{Data}{either a dataframe or a matrix, representing raw interactions
using either an edgelist or a matrix.
Frequency of interactions for each dyad can be represented either
by multiple occurrences of the dyad for a 2-column edgelist, or
by a third column specifying the frequency of the interaction
for a 3-column edgelist.}

\item{weighted}{If the edgelist is a 3-column edgelist in which weight was
specified by frequency, use \code{weighted = TRUE}.}

\item{rule}{a character vector of length 1, being one of "\code{weak}",
"\code{strong}", "\code{upper}", or "\code{lower}".
Ways of symmetrizing the matrix. See details for more information.}
}
\value{
a named matrix with the \code{[i,j]}th entry equal to the
number of times \code{i} grooms \code{j}.
}
\description{
\code{as.symmetricAdjacencyMatrix} convert an edgelist or a raw matrix to a symmetric adjacency matrix.
}
\details{
There are ways of symmetrizing a matrix.
The "\code{weak}" rule symmetrize the matrix by building an edge
between nodes \code{[i, j]} and \code{[j, i]} if there is an edge
either from \code{i} to \code{j} OR from \code{j} to \code{i}.
The "\code{strong}" rule symmetrize the matrix by building an edge
between nodes \code{[i, j]} and \code{[j, i]} if there is an edge
BOTH from \code{i} to \code{j} AND from \code{j} to \code{i}.
The "\code{upper}" and the "\code{lower}" rule symmetrize the matrix
by using the "\code{upper}" or the "\code{lower}" triangle respectively.


Note, when using a 3-column edgelist (e.g. a weighted edgelist) to
represent raw interactions, each dyad must be unique.
If more than one rows are found with the same Initiator and recipient,
sum of the frequencies will be taken to represent the freqency of
interactions between this unique dyad.
A warning message will prompt your attention to the accuracy of your
raw data when duplicated dyads were found in a three-column edgelist.
}
\examples{
symmetricMatrix <- as.symmetricAdjacencyMatrix(monkeyGrooming, weighted = TRUE, rule = "weak")

}
