% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize.R
\name{colNormalize}
\alias{colNormalize}
\alias{colNormalize.default}
\alias{colNormalize.dgCMatrix}
\alias{colNormalize.Seurat}
\alias{colNormalize.SingleCellExperiment}
\title{Normalize each column of the input matrix by the column sum}
\usage{
colNormalize(x, scaleFactor = NULL, log = FALSE, ...)

\method{colNormalize}{default}(x, scaleFactor = NULL, log = FALSE, ...)

\method{colNormalize}{dgCMatrix}(x, scaleFactor = NULL, log = FALSE, ...)

\method{colNormalize}{Seurat}(
  x,
  scaleFactor = NULL,
  log = FALSE,
  assay = NULL,
  layer = "counts",
  ...
)

\method{colNormalize}{SingleCellExperiment}(x, scaleFactor = NULL, log = FALSE, assay.type = "counts", ...)
}
\arguments{
\item{x}{Feature by observation matrix. Alternatively, \code{Seurat} object
or \code{SingleCellExperiment} object with raw counts available are also
supported.}

\item{scaleFactor}{Multiplier on normalized data. Default \code{NULL}.}

\item{log}{Logical. Whether to take log1p transformation after scaling.
Default \code{FALSE}}

\item{...}{Additional arguments passed to methods}

\item{assay}{For "Seurat" method, the specific assay to get data from.
Default \code{NULL} to the default assay.}

\item{layer}{For "Seurat" method, which layer of the assay to be used.
Default \code{"counts"}.}

\item{assay.type}{For "SingleCellExperiment" method, the assay type to get
data from. Default \code{"counts"}.}
}
\value{
Normalized matrix of the same size

A Seurat object with normalized data in the specified slot of the
specified assay.

A SingleCellExperiment object with normalized data in the specified
assay. \code{"normcounts"} if \code{log = FALSE} and \code{"logcounts"} if
\code{log = TRUE}.
}
\description{
Normalize each column of the input matrix by the column sum
}
\examples{
rnaNorm <- colNormalize(rnaRaw)
\donttest{
# Seurat example
library(Seurat)
srt <- CreateSeuratObject(rnaRaw)
srt <- colNormalize(srt)
}
\donttest{
# SingleCellExperiment example
library(SingleCellExperiment)
sce <- SingleCellExperiment(assays = list(counts = rnaRaw))
sce <- colNormalize(sce)
}
}
