% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quaternary.R
\name{plotQuaternary.simMat}
\alias{plotQuaternary.simMat}
\title{Create quaternary simplex plot with pre-calculated similarity matrix}
\usage{
\method{plotQuaternary}{simMat}(
  x,
  veloMat = NULL,
  nGrid = 10,
  radius = 0.2,
  dotSize = NULL,
  colorArg = NULL,
  labelColors = c("#3B4992FF", "#EE0000FF", "#008B45FF", "#631879FF"),
  arrowLinewidth = NULL,
  arrowAngle = 20,
  arrowLen = 0.1,
  vertexLabelSize = NULL,
  edgeLinewidth = 1,
  title = NULL,
  titleSize = 1,
  titleColor = "black",
  theta = 20,
  phi = 0,
  interactive = TRUE,
  ...
)
}
\arguments{
\item{x}{simMat object, n cells by 4 vertices, each row summing to 1.}

\item{veloMat}{Aggregated velocity matrix. Output of \code{aggrVeloGraph}.}

\item{nGrid}{Number of grids along the x-axis of the tetrahedron. Default
\code{10}.}

\item{radius}{Arrow length of unit velocity. Lower this when arrows point
outside of the tetrahedron. Default \code{0.2}.}

\item{dotSize}{Size of each dot. Default \code{0.6} for static figure, and
\code{4} for interactive view.}

\item{colorArg}{A "colorArg" object, internally prepared by
\code{\link{plotQuaternary.default}}. Default \code{NULL}.}

\item{labelColors}{Colors of the vertex labels. Default
\code{c("#3B4992FF", "#EE0000FF", "#008B45FF", "#631879FF")} (blue, red,
green and purple).}

\item{arrowLinewidth}{Arrow aesthetics. Default \code{1.6} for interactive
view, \code{0.6} for static figure.}

\item{arrowAngle, arrowLen}{Arrow aesthetics passed to TODOOOO
\code{grid::\link[grid]{arrow}}. The length of the arrow will be internally
converted to unit onject in inches. Default \code{20} and \code{0.1}.}

\item{vertexLabelSize}{Numeric, size of vertex text label relative to default
size. Default \code{1}.}

\item{edgeLinewidth}{Controls the linewidth of the edges of the tetrahedron.
Default \code{1}.}

\item{title}{Title text of the plot. Default \code{NULL}.}

\item{titleSize, titleColor}{Setting on the main title text. Default \code{1},
and \code{"black"}.}

\item{theta, phi}{Numeric scalar. The angles defining the viewing direction.
\code{theta} gives the azimuthal direction and \code{phi} the colatitude.
Default \code{20} and \code{0}.}

\item{interactive}{Logical. Whether to display plotly interactive view.
Default \code{TRUE}.}

\item{...}{Not used}
}
\value{
A "quatPlot" object, can be displayed by printing.
}
\description{
Create quaternary simplex plot with pre-calculated similarity matrix
}
