% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ic_scmprisk_spTran_copula.R
\name{ic_scmprisk_spTran_copula}
\alias{ic_scmprisk_spTran_copula}
\title{Copula regression models with semi-parametric transformation margins for semi-competing risk data under interval-censoring and left-truncation}
\source{
Tao Sun, Yunlong Li, Zhengyan Xiao, Ying Ding, Xiaojun Wang (2022).
Semiparametric copula method for semi-competing risks data
subject to interval censoring and left truncation:
Application to disability in elderly. Statistical Methods in Medical Research (Accepted).
}
\usage{
ic_scmprisk_spTran_copula(
  data,
  var_list,
  copula = "Copula2",
  l1 = 0,
  u1,
  m1 = 3,
  r1 = 1,
  l2 = 0,
  u2,
  m2 = 3,
  r2 = 1,
  method = "BFGS",
  iter = 1000,
  stepsize = 1e-05,
  control = list(),
  eta_ini = NULL
)
}
\arguments{
\item{data}{a data frame; must have \code{id} (subject id), \code{Left} (0 if left-censoring for non-terminal event),
\code{Right} (Inf if right-censoring for non-terminal event), \code{status} (0 for right-censoring,
1 for interval-censoring or left-censoring of non-terminal event), \code{timeD} (observed terminal event),
\code{statusD} (for terminal event), \code{A} (left truncation time, 0 if none), and \code{covariates} by column.}

\item{var_list}{the list of covariates to be fitted into the copula model.}

\item{copula}{Types of copula model, only Copula2 is supported at this stage.}

\item{l1}{for non-terminal event, the left bound for all \code{Left} and \code{Right} endpoints of observed finite intervals;
default is 0.}

\item{u1}{for non-terminal event, the right bound for all \code{Left} and \code{Right} endpoints of observed finite intervals;
has to be a finite value}

\item{m1}{for non-terminal event, integer, degree of Berstein polynomials for both margins; default is 3}

\item{r1}{for non-terminal event, postive transformation parameter for the semiparametric transformation marginal model.}

\item{l2}{for terminal event, the left bound for all \code{Left} and \code{Right} endpoints of observed finite intervals;
default is 0.}

\item{u2}{for terminal event, the right bound for all \code{Left} and \code{Right} endpoints of observed finite intervals;
has to be a finite value}

\item{m2}{for terminal event, integer, degree of Berstein polynomials for both margins; default is 3}

\item{r2}{for terminal event, postive transformation parameter for the semiparametric transformation marginal model.}

\item{method}{optimization method (see ?optim); default is "BFGS";
also can be "Newton" (see ?nlm).}

\item{iter}{number of iterations when method is \code{"Newton"};
default is 300.}

\item{stepsize}{size of optimization step when method is \code{"Newton"};
default is 1e-5.}

\item{control}{a list of control parameters for methods other than \code{"Newton"};
see \code{?optim}.}

\item{eta_ini}{a vector of initial values for copula parameters, default is NULL}
}
\value{
a \code{CopulaCenR} object summarizing the model.
Can be used as an input to general \code{S3} methods including
\code{summary}, \code{print}, \code{coef},
\code{logLik}, \code{AIC}, \code{BIC}.
}
\description{
Fits a copula model with semi-parametric transformation margins for semi-competing risk data under interval-censoring and left-truncation.
}
\details{
The input data must be a data frame. with columns \code{id} (sample id),
\code{Left} (0 if left-censoring), \code{Right} (Inf if right-censoring),
\code{status} (0 for right-censoring, 1 for interval-censoring or left-censoring),
\code{timeD} (for terminal event), \code{statusD},\code{A} (0 if no left truncation),
and \code{covariates}. The function does not allow \code{Left} == \code{Right}. \cr


The supported copula model in this version is \code{"Copula2"}.
The \code{"Copula2"} model is a two-parameter copula model that incorporates \code{Clayton}
and \code{Gumbel} as special cases.
The parametric generator functions of copula functions are list below:

The Two-parameter copula (Copula2) has a generator \deqn{\phi_{\eta}(t) = \{1/(1+t^{\alpha})\}^{\kappa},}
with \eqn{\alpha \in (0,1], \kappa > 0} and Kendall's \eqn{\tau = 1-2\alpha\kappa/(2\kappa+1)}. \cr


The marginal semiparametric transformation models are built based on Bernstein polynomials, which is formulated below:

\deqn{S(t|Z) = \exp[-G\{\Lambda(t) e^{Z^{\top}\beta}\}],} where \eqn{t} is time, \eqn{Z} is covariate,
\eqn{\beta} is coefficient and \eqn{\Lambda(t)} is an unspecified function with infinite dimensions.
We approximate \eqn{\Lambda(t)} in a sieve space constructed by Bernstein polynomials with degree \eqn{m}. By default, \eqn{m=3}.
In the end, all model parameters are estimated by the sieve estimators (Sun and Ding, In Press).

The \eqn{G(\cdot)} function is the transformation function with a parameter \eqn{r > 0}, which has a form of
\eqn{G(x) = \frac{(1+x)^r - 1}{r}}, when \eqn{0 < r \leq 2} and \eqn{G(x) = \frac{\log\{1 + (r-2)x\}}{r - 2}} when \eqn{r > 2}.
When \eqn{r = 1}, the marginal model becomes a proportional hazards model;
when \eqn{r = 3}, the marginal model becomes a proportional odds model.
In practice, \code{m} and \code{r} can be selected based on the AIC value. \cr

Optimization methods can be all methods (except \code{"Brent"}) from \code{optim}, such as
\code{"Nelder-Mead"}, \code{"BFGS"}, \code{"CG"}, \code{"L-BFGS-B"}, \code{"SANN"}.
Users can also use \code{"Newton"} (from \code{nlm}).
}
\examples{
# fit a Copula2-Semiparametric model
data("data_scmprisk")
copula2_sp <- ic_scmprisk_spTran_copula(data = data_scmprisk,
              var_list = c("x1"), copula = "Copula2",
              l1=0, u1 = 21, m1 = 3, r1 = 1,
              l2=0, u2 = 21, m2 = 3, r2 = 1,
              )
summary(copula2_sp)
}
