% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prod_mod.R
\name{prod_mod_conc}
\alias{prod_mod_conc}
\alias{prod_mod}
\alias{prod_mod_flux}
\title{prod_mod}
\usage{
prod_mod_conc(prod, height, DS, F0, C0)

prod_mod_flux(prod, height, F0)
}
\arguments{
\item{prod}{the production assigned to this step production in
\eqn{\mu~mol/s/m^3}}

\item{height}{the height of each step in m}

\item{DS}{the diffusion coefficient DS in \eqn{m^2/s}}

\item{F0}{(numeric) Incoming flux to lowest step in \eqn{\mu mol/m^2/s}}

\item{C0}{(numeric) Concentration at the lower end of the lowest step in
\eqn{\mu mol/m^3}.}
}
\value{
\code{conc} in \eqn{\mu mol/m^3} or
\code{flux} in \eqn{\mu mol/m^2/s} at top of each step.
}
\description{
These functions calculates flux or concentration profile of a
gas based on fixed production and known diffusion coefficient Ds. The basis
is a step-wise calculation beginning from the bottom-most layer with
incoming flux F0 and known concentration C0 at the lower end of the step.

The following input parameters must be vectors sorted from the lowest depth
of the profile to the highest. Note that the assigned units are examples.
However, units should be concise and match over all parameters. The
functions are designed to be used in optimization and are hence as fast as
possible.
}
\section{Functions}{
\itemize{
\item \code{prod_mod_flux()}: flux output only

}}
\examples{
prod_mod_conc(prod = c(0.01,0.02,0.65,0.5,0.4),
              height = c(0.5,0.2,0.1,0.03,0.02),
              DS = c(rep(2.5E-7,3),rep(1E-6,2)),
              F0=0,
              C0=48000E-6)
prod_mod_flux(prod = c(0.01,0.02,0.65,0.5,0.4),
              height = c(0.5,0.2,0.1,0.03,0.02),
              F0=0
              )
}
\seealso{
Other proflux: 
\code{\link{prod_optim}()}
}
\concept{proflux}
\keyword{internal}
