% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfp_altres.R
\name{cfp_altres}
\alias{cfp_altres}
\title{Model runs as result of parameter variation}
\usage{
cfp_altres(
  x,
  og_model,
  f,
  run_map,
  return_raw = TRUE,
  error_funs = NULL,
  error_args = NULL
)
}
\arguments{
\item{x}{A named list of cfp_pfres or cfp_fgres models.}

\item{og_model}{The original model that was altered}

\item{f}{A function taking in a soilphys object and recalculates the relevant
columns. See \code{\link[=complete_soilphys]{complete_soilphys()}}.}

\item{run_map}{A data.frame created by \code{\link[=run_map]{run_map()}} with the necessary
information how the data is to be changed with each distinct \code{run_id}.}

\item{return_raw}{Should the models be returned as is, or after applying any
\code{error_funs}. Default is \code{TRUE} - exporting the models.}

\item{error_funs}{A list of functions to be applied after flux calculation if
\code{return_raw == FALSE}. This can be used to output not the models but
quality parameters instead. Output must contain the column RMSE.}

\item{error_args}{A list of additional function arguments to be passed to any
of the \code{error_funs}. Must match the length of \code{error_funs}}
}
\value{
A \code{list} of mdoel results of type \code{cfp_altres}.
}
\description{
S3 class for the result of a call to alternate().
Essentially a list with added run_map and further attributes.
}
\examples{
# internal
PROFLUX <- ConFluxPro::base_dat |> pro_flux()

cfp_altres(list(PROFLUX), PROFLUX, complete_soilphys, data.frame(run_id = 1))

}
\seealso{
Other model frames: 
\code{\link{cfp_fgmod}()},
\code{\link{cfp_fgres}()},
\code{\link{cfp_pfmod}()},
\code{\link{cfp_pfres}()}
}
\concept{model frames}
\keyword{internal}
