% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VariationScenario.R
\name{VariationScenario}
\alias{VariationScenario}
\title{Scenarios for variation in CoDa regressions models}
\usage{
VariationScenario(
  object,
  Xvar,
  Xdir,
  obs = 1,
  inc_size = 0.1,
  n_steps = 100,
  add_opposite = TRUE,
  normalize_Xdir = TRUE
)
}
\arguments{
\item{object}{an object of class "lmCoDa"}

\item{Xvar}{a character indicating the name of the explanatory variable that changes}

\item{Xdir}{either character or numeric, to indicate the direction in which Xvar should change
\itemize{
\item when character this should be one of the components of X, in which case the direction is the corresponding vertex of the simplex
\item when numeric this argument is coerced to a unit vector in the simplex
\item (when Xvar refers to a scalar variable this argument is ignored)
}}

\item{obs}{a numeric indicating the observation used for the scenario}

\item{inc_size}{a numeric indicating the distance between each point in the scenario of X}

\item{n_steps}{a numeric indicating the number of points in the scenario}

\item{add_opposite}{a logical, if \code{TRUE} the scenario also includes changes in the opposite direction}

\item{normalize_Xdir}{a logical, if \code{TRUE} the direction \code{Xdir} scaled to have an Aitchison norm of 1, allowing to interpret \code{inc_size} as the Aitchison distance}
}
\value{
a data.frame containing the scenario of X and the corresponding predicted values of Y
}
\description{
Scenarios of this type are illustrated in Dargel and Thomas-Agnan (2024).
They allow to evaluate how the response variable (Y) in a CoDa model would evolve under a hypothetical scenario for linear changes in one explanatory variable (X).
When the changing explanatory variable is compositional the term "linear" is understood with respect to the geometry of the simplex.
}
\details{
The linear scenario for X is computed with \code{\link[=seq]{seq()}} in the scalar case and with \code{\link[=CoDa_seq]{CoDa_seq()}} in the compositional case.
The corresponding changes in Y are computed with the prediction formula, where we exploit the fact that only in one variable is changing.
}
\examples{

# ---- model with scalar response ----
res <- lmCoDa(YIELD ~ PRECIPITATION + ilr(TEMPERATURES), data = head(rice_yields,20))
VariationScenario(res, Xvar = "TEMPERATURES", Xdir = "MEDIUM", n_steps = 5)
VariationScenario(res, Xvar = "PRECIPITATION", n_steps = 5)


# ---- model with compositional response ----
res <- lmCoDa(ilr(cbind(left, right, extreme_right)) ~
                ilr(cbind(Age_1839, Age_4064)) +
                ilr(cbind(Educ_BeforeHighschool, Educ_Highschool, Educ_Higher)) +
                log(unemp_rate),
              data = head(election))

VariationScenario(res, Xvar ="cbind(Age_1839,Age_4064)",Xdir = "Age_1839", n_steps = 5)
VariationScenario(res, "log(unemp_rate)", n_steps = 5)

}
\references{
\itemize{
\item Dargel, Lukas and Christine Thomas-Agnan, “Pairwise share ratio interpretations of compositional regression models”, Computational Statistics & Data Analysis 195 (2024), p. 107945
}
}
\author{
Lukas Dargel
}
