% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bread.R
\docType{data}
\name{bread}
\alias{bread}
\title{Loaf volumes from a bread-baking experiment}
\format{
A tibble with 85 rows and 3 columns:
\describe{
\item{variety}{a factor indicating the variety of flour used.}
\item{bromate}{a number denoting the amount of potassium bromate used
(milligrams).}
\item{volume}{a number denoting the volume of the loaf made under
each condition (milliliters).}
}
}
\source{
Larmour, R. K. (1941). A comparison of hard red spring and hard red
winter wheats. \emph{Cereal Chemistry, 18}(6), 778-789. Available at:
\url{https://archive.org/details/sim_cereal-chemistry_1941-11_18_6}
}
\usage{
bread
}
\description{
Includes the volumes (ml) of 85 loaves of bread made under controlled
conditions from 100-gram batches of dough made with 17 different varieties of
wheat flour and 5 levels of potassium bromate (mg).
}
\details{
Data from a bread-baking experiment by Larmour (1941). Later reproduced by
Scheffe (1959) and then used by Duncan (1965) to contrast different multiple
comparison methods. Jolliffe (1975) applies this dataset to illustrate his
cluster-based test.
}
\examples{
data(bread)
summary(bread)
}
\references{
Duncan, D. B. (1965). A bayesian approach to multiple
comparisons. \emph{Technometrics, 7}(2), 171-222.
\doi{doi:10.2307/1266670}

Jolliffe, I. T. (1975). Cluster analysis as a multiple comparison
method. \emph{Applied Statistics: Proceedings of Conference at Dalhousie
University, Halifax}, 159-168.

Scheffe, H. (1950).\emph{The analysis of variance}. Wiley-Interscience
Publication.
}
\keyword{datasets}
