## 2024-07-17
## Function that fits Augmented Gamma Distribution
## Jonathon Jacobs

nllag <- function(par, data, shape = FALSE) {
	if (shape == FALSE) {
		shape <- par[1]
		scale <- par[2]
		p0 <- par[3]
	} else {
		scale <- par[1]
		p0 <- par[2]
	}

	-(sum(data != 0) * log(1 - p0) + sum(data == 0) * log(p0) +
			sum(stats::dgamma(data[data != 0], shape, scale = scale, log = TRUE)))
}
