#' @keywords internal
#' @noRd

circ_sd_minutes <- function(mins_of_day) {
  x <- mins_of_day %% 1440              # wrap to 24h just in case
  theta <- 2*pi*x/1440                  # minutes -> radians
  C <- mean(cos(theta), na.rm = TRUE)
  S <- mean(sin(theta), na.rm = TRUE)
  R <- sqrt(C*C + S*S)                  # mean resultant length (0..1)
  if (!is.finite(R) || R <= 0) return(NA_real_)
  sd_rad <- sqrt(-2*log(R))             # Fisher circular SD (radians)
  (1440/(2*pi)) * sd_rad                # radians -> minutes
}
