\name{axialnntsmanifoldnewtonestimationgradientstopsymmetric}
\alias{axialnntsmanifoldnewtonestimationgradientstopsymmetric}
\title{
Parameter estimation for axial symmetric NNTS distributions with gradient stop
}
\description{
Computes the maximum likelihood estimates of the parameters of an axial symmetric NNTS distribution, using a Newton algorithm on the hypersphere and considering a maximum number of iterations determined by a constraint in terms of the norm of the gradient
}
\usage{
axialnntsmanifoldnewtonestimationgradientstopsymmetric(data, M = 0, iter = 1000, 
gradientstop = 1e-10, pevalmu = 1000, initialpoint = FALSE, cinitial)
}
\arguments{
  \item{data}{Vector of axial angles in radians}
  \item{M}{Number of components in the NNTS axial model}
  \item{iter}{Number of iterations}
  \item{gradientstop}{The minimum value of the norm of the gradient to stop the Newton algorithm on the hypersphere}
  \item{pevalmu}{Number of equidistant points in the interval 0 to pi to search for the maxima of the angle of symmetry}
  \item{initialpoint}{TRUE if an initial point for the optimization algorithm for the axial NNTS density will be used}
  \item{cinitial}{Vector of size M+1. The first element is real and the next M elements are complex (values for $c_0$ and $c_1, ...,c_M$). The sum of the squared moduli of the parameters must be equal to 1/pi.}
}

\value{A list with 13 elements:
\item{cestimatessym}{Matrix of (M+1)x2. The first column is the parameter numbers, and the second column is the c parameter's estimators of the symmetric NNTS axial model}
\item{mu}{Estimate of the angle of symmetry of the NNTS symmetric axial model}
\item{logliksym}{Optimum log-likelihood value for the NNTS symmetric axial model}
\item{AICsym}{Value of Akaike's Information Criterion for the NNTS symmetric axial model}
\item{BICsym}{Value of Bayesian Information Criterion for the NNTS symmetric axial model}
\item{gradnormerrorsym}{Gradient error after the last iteration for the estimation of the parameters of the NNTS symmetric axial model}
\item{cestimatesnonsym}{Matrix of (M+1)x2. The first column is the parameter numbers, and the second column is the c parameter's estimators of the general (non-symmetric) NNTS axial model}
\item{logliknonsym}{Optimum log-likelihood value for the general (non-symmetric) NNTS axial model}
\item{AICnonsym}{Value of Akaike's Information Criterion for the general (non-symmetric) NNTS axial model}
\item{BICnonsym}{Value of Bayesian Information Criterion for the general (non-symmetric) NNTS axial model}
\item{gradnormerrornonsym}{Gradient error after the last iteration for the estimation of the parameters of the general (non-symmetric) NNTS axial model}
\item{loglikratioforsym}{Value of the likelihood ratio test statistic for symmetry}
\item{loglikratioforsympvalue}{Value of the asymptotic chi squared p-value of the likelihood ratio test statistic for symmetry}
}

\author{
Juan Jose Fernandez-Duran and Maria Mercedes Gregorio-Dominguez
}
\references{
Fernandez-Duran, J.J. and Gregorio-Dominguez, M.M. (2025). Multimodal distributions for circular axial data. arXiv:2504.04681 [stat.ME] (available at https://arxiv.org/abs/2504.04681)

Fernández-Durán, J.J., Gregorio-Domínguez, M.M. (2025). Multimodal Symmetric Circular Distributions Based on Nonnegative Trigonometric Sums and a Likelihood Ratio Test for Reflective Symmetry, arXiv:2412.19501 [stat.ME] (available at https://arxiv.org/abs/2412.19501)
}
\examples{
data(Datab2fisher)
feldsparsangles<-Datab2fisher
feldsparsangles<-feldsparsangles$orientations*(pi/180)
resfeldsparsymm<-axialnntsmanifoldnewtonestimationgradientstopsymmetric(data=feldsparsangles, 
M = 2, iter =1000, gradientstop=1e-10,pevalmu=1000)
resfeldsparsymm
hist(feldsparsangles,breaks=seq(0,pi,pi/7),xlab="Orientations (radians)",freq=FALSE,
ylab="",main="",ylim=c(0,.8),axes=FALSE)
axialnntsplot(resfeldsparsymm$cestimatessym[,2],2,add=TRUE)
axialnntsplot(resfeldsparsymm$cestimatesnonsym[,2],2,add=TRUE,lty=2)
axis(1,at=c(0,pi/2,pi),labels=c("0",expression(pi/2),expression(pi)),las=1)
axis(2)
}
