% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l.s.R
\name{l.s}
\alias{l.s}
\title{Linear relation for SNVs}
\usage{
l.s(cnt, cnb1, cnb2, pc = 0, ps = NULL, baf = NULL)
}
\arguments{
\item{cnt}{is number with the total copy number after the CNAs mutation.}

\item{cnb1}{is number with the B copy number of two types of periods. The first period, the proportion of CNAs mutation is more than the proportion of SNVs mutation then cnb1 is B copy number after SNVs mutation. The second period, the proportion of CNAs mutation is less than the proportion of SNVs mutation then cnb1 is B copy number between the SNVs mutation and CNAs mutation.}

\item{cnb2}{is number with the B copy number of two types of periods. The first period, the proportion of CNAs mutation is less than the proportion of SNVs mutation then cnb1 is B copy number after CNAs mutation. The second period, the proportion of CNAs mutation is more than the proportion of SNVs mutation then cnb1 is B copy number between the CNAs mutation and SNVs mutation.}

\item{pc}{is number with the proportion of CNAs mutation and the default is 0.}

\item{ps}{is number with the proportion of SNVs mutation and the default is NULL.}

\item{baf}{is number with the B allele frequence and the default is NULL.}
}
\value{
baf is number with B allele frequence(baf) if the input is given the proportion of SNVs mutation(ps).

ps is number with the proportion of SNVs mutation(ps) if the input is given the B allele frequence(baf).
}
\description{
l.s is the linear relation between B allele frequence and the proportion of SNVs mutation(PS).
}
\details{
l.s is bidirection function. The first function is given the proportion of SNVs mutation(ps) to predict the B allele frequence(baf). The second function is given the B allele frequence(baf) to predict the proportion of SNVs mutation(ps).
}
\author{
Peter Wu (peter123wu0@gmail.com)
}

