% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_funcs.R
\name{CRT_fatigueeffect}
\alias{CRT_fatigueeffect}
\title{Testing fatigue effect in Conjoint Experiments}
\usage{
CRT_fatigueeffect(
  formula,
  data,
  left,
  right,
  task,
  respondent,
  profileorder_constraint = TRUE,
  non_factor = NULL,
  B = 200,
  parallel = TRUE,
  num_cores = 2,
  nfolds = 3,
  lambda = c(20, 30, 40),
  tol = 0.001,
  speedup = TRUE,
  seed = sample(c(1:1000), size = 1),
  verbose = TRUE
)
}
\arguments{
\item{formula}{A formula object specifying the outcome variable on the left-hand
side and factors of (X,Z) and respondent characteristics (V) in the right hand side.
RHS variables should be separated by + signs and should only contain either
left or right for each (X,Z).
For example Y ~ Country_left + Education_left is sufficient as opposed to
Y ~ Country_left + Country_right + Education_left + Education_right}

\item{data}{A dataframe containing outcome variable and all factors (X,Z,V)
(including both left and right profile factors). All (X,Z,V) listed in
the formula above are expected to be of class factor unless explicitly stated
in non_factor input.}

\item{left}{Vector of column names of data that corresponds to the left profile factors}

\item{right}{Vector of column names of data that corresponds to the right profile factors.
NOTE: left and right are assumed to be the same length and the
order should correspond to the same variables. For example left =
c("Country_left", "Education_left") and right = c("Country_right", "Education_right")}

\item{task}{A character string indicating column of data that contains the task
evaluation. IMPORTANT: The task variable is assumed to have no missing tasks, i.e.,
each respondent should have 1:J tasks. Please drop respondents with missing tasks.}

\item{respondent}{A character string indicating column of data that contains the
respondent index. The column should contain integers from 1:N indicating respondent index.}

\item{profileorder_constraint}{Boolean indicating whether to enforce profile order
constraint (default = TRUE)}

\item{non_factor}{A vector of strings indicating columns of data that are not factors.
This should only be used for respondent characteristics (V) that are not factors.
For example non_factor = "Respondent_Age".}

\item{B}{Numeric integer value indicating the number of resamples for the CRT procedure.
Default value is B=200.}

\item{parallel}{Boolean indicating whether parallel computing should be used.
Default value is TRUE.}

\item{num_cores}{Numeric integer indicating number of cores to use when parallel=TRUE.
num_cores should not exceed the number of cores the user's machine can handle. Default is 2.}

\item{nfolds}{Numeric integer indicating number of cross-validation folds. Default is 3.}

\item{lambda}{Numeric vector indicating lambda used for cross-validation for HierNet fit.
Default lambda=c(20,30,40).}

\item{tol}{Numeric value indicating acceptable tolerance for terminating optimization
fit for HierNet. Default is tol=1e-3. WARNING: Do not increase as it greatly increases
computation time.}

\item{speedup}{Boolean indicating whether to employ computational tricks to make
function run faster. It is always recommended to use default speedup=TRUE.}

\item{seed}{Seed used for CRT procedure}

\item{verbose}{Boolean indicating verbose output. Default verbose=TRUE}
}
\value{
A list containing: \item{p_val}{A numeric value for the p-value testing
fatigue effect.}
\item{obs_test_stat}{A numeric value for the observed test statistic.}
\item{resampled_test_stat}{Matrix containing all the B resampled test statistics}
\item{tol}{Tolerance used for HierNet}
\item{lam}{Best cross-validated lambda}
\item{hiernet_fit}{An object of class hiernet that contains the hiernet fit for
the observed test statistic}
\item{seed}{Seed used}
\item{elapsed_time}{Elapsed time}
}
\description{
This function takes a conjoint dataset and returns the p-value when using the
CRT to test if the fatigue effect holds using HierNet test statistic.
The function requires user to specify the outcome, all factors used in the
conjoint experiment, and both the evaluation task number and respondent index.
The function assumes the forced choice conjoint experiment and consequently
assumes the data to contain the left and right profile factors in separate
column in the dataset supplied.
}
\examples{
# Subset of Immigration Choice Conjoint Experiment Data from Hainmueller et. al. (2014).
data("immigrationdata")
form = formula("Y ~ FeatEd + FeatGender + FeatCountry + FeatReason + FeatJob +
FeatExp + FeatPlans + FeatTrips + FeatLang + ppage + ppeducat + ppethm + ppgender")
left = colnames(immigrationdata)[1:9]
right = colnames(immigrationdata)[10:18]
# Each respondent evaluated 5 tasks
J = 5
fatigue_df = immigrationdata
fatigue_df$task = rep(1:J, nrow(fatigue_df)/J)
fatigue_df$respondent = rep(1:(nrow(fatigue_df)/J), each = J)
\donttest{
fatigue_test = CRT_fatigueeffect(formula = form, data = fatigue_df, left = left,
right = right, task = "task", respondent = "respondent", B = 50)
fatigue_test$p_val
}
}
\references{
Ham, D., Janson, L., and Imai, K.
(2022) Using Machine Learning to Test Causal Hypotheses in Conjoint Analysis
}
