% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpsurv.R
\name{cpsurv}
\alias{cpsurv}
\title{Nonparametric Change Point Estimation}
\usage{
cpsurv(time, event, cpmax, intwd, cpmin = 0, censoring = c("random",
  "type1", "no"), censpoint = NULL, biascorrect = FALSE,
  parametric = FALSE, B.correct = 49, opt.start = c(0.1, 50),
  boot.ci = FALSE, B = 999, conf.level = 0.95, norm.riskset = TRUE,
  seed = NULL, parallel = TRUE, cores = 4L)
}
\arguments{
\item{time}{Numeric vector with survival times.}

\item{event}{Numeric vector indicating censoring status; 0 = alive (censored), 1 =
dead (uncensored). If missing, all observations are assumed to be
uncensored.}

\item{cpmax}{Upper bound for estimated change point. Time period is split into
intervals up to this point. Has to be an integer value.}

\item{intwd}{Width of intervals into which the time period is split; default
is \code{ceiling(cpmax/20)}. Has to be an integer value.}

\item{cpmin}{Lower bound for estimated change point; default is
\code{cpmin=0}. Has to be an integer value.}

\item{censoring}{Type of right-censoring for simulated data on which the
bootstrap bias correction is based. Possible types are "random" for
\emph{random censoring} (default), "type1" for \emph{Type I censoring} or
"no" for data without censored observations. Because simulated data should
be similar to given data, the censoring type is adapted from vector
'events' if given and argument 'censoring' is ignored than.}

\item{censpoint}{Point of \emph{Type I censoring}; if missing, minimum time
after which all events are equal to 0 is used. Censpoint is only needed for
bootstrap bias correction.}

\item{biascorrect}{Logical; if \code{TRUE}, a bootstrap bias correction is
performed; see 'Details'.}

\item{parametric}{Indicator for parametric bias-correction (see Details for
more information).}

\item{B.correct}{Number of bootstrap samples for bias-correction; defaults to
49.}

\item{opt.start}{Numeric vector of length two; initial values for the Weibull
parameters (shape and scale parameters) to be optimized if parametric
bootstrap bias correction is used.}

\item{boot.ci}{Indicator if confidence intervals (and thereby standard
deviation) should be calculated by bootstrap sampling. Please note the
extended runtime (see details for examples).}

\item{B}{Number of bootstrap samples for confidence intervals; defaults to
999.}

\item{conf.level}{Confidence level for bootstrap confidence intervals.}

\item{norm.riskset}{Logical; if \code{TRUE} normalized number of units at
risk is used within an interval.}

\item{seed}{Seed for random number generator (optional).}

\item{parallel}{Indicator if bootstrap-sampling is executed parallelized
(based on package 'parallel'); operating system is identified
automatically.}

\item{cores}{Number of CPU-cores that are used for parallelization; maximum
possible value is the detected number of logical CPU cores.}
}
\value{
\tabular{ll}{ \code{cp}\tab estimated change point\cr
  \code{p.values}\tab p-values resulting from exact binomial test\cr
  \code{pv.mean}\tab mean of p-values for intervals above the estimated
  change point\cr \code{lower.lim}\tab lower interval limits\cr
  \code{upper.lim}\tab upper interval limits\cr \code{cp.bc}\tab bias
  corrected change point\cr \code{ml.shape}\tab ML estimator of shape
  parameter for Weibull distribution\cr \code{ml.scale}\tab ML estimator of
  scale parameter for Weibull distribution\cr \code{cp.boot}\tab estimated
  change points for bootstrap samples\cr \code{sd}\tab standard deviation
  estimated by bootstrap sampling\cr \code{ci.normal}\tab confidence interval
  with normal approximation\cr \code{ci.percent}\tab bootstrap percentile
  interval\cr \code{conf.level}\tab the \code{conf.level} argument passed to
  \code{cpsurv}\cr \code{B}\tab the \code{B} argument passed to
  \code{cpsurv}\cr \code{time}\tab the \code{time} argument passed to
  \code{cpsurv}\cr \code{event}\tab the \code{event} argument passed to
  \code{cpsurv}\cr \code{cpmax}\tab the \code{cpmax} argument passed to
  \code{cpsurv}\cr \code{intwd}\tab the \code{intwd} argument passed to
  \code{cpsurv}\cr \code{call}\tab matched call}
}
\description{
Change point estimation for survival data based on exact
  binomial test.
}
\details{
Change point is a point in time, from which on the hazard rate is
  supposed to be constant. For its estimation the timeline up to \code{cpmax}
  is split into equidistant intervals of width \code{intwd} and exact
  binomial tests are executed for each interval. The change point is
  estimated by fitting a regression model on the resulting p-values. See
  Brazzale \emph{et al} (2017) for details. \cr\cr For bootstrap bias
  correction the change point is estimated for a given number
  (\code{B.correct}) of bootstrap samples whereupon the bias is built by
  subtracting their median from primary estimation. Depending on argument
  \code{parametric} the data for bootstrapping are simulated either
  parametric (Weibull distributed with estimated shape and scale parameters)
  or nonparametric (based on Kaplan-Meier estimation).
}
\examples{
data(survdata)
# estimate change point for survdata (random censored)
cp <- cpsurv(survdata$time, survdata$event, cpmax = 360, intwd = 20)
summary(cp)

\dontrun{
# estimation with parametric bootstrap bias correction
cp_param <- cpsurv(survdata$time, survdata$event, cpmax = 360, intwd = 20,
            biascorrect = TRUE, parametric = TRUE)
summary(cp_param)

# with bootstrap confidence intervals and parametric bootstrap bias
cp_ci <- cpsurv(survdata$time, survdata$event, cpmax = 360, intwd = 20,
biascorrect = TRUE, parametric = FALSE, boot.ci = TRUE, cores = 4, seed = 36020)
# runtime: approx. 180 min (with Intel(R) Core(TM) i7 CPU 950 @ 3.07GHz, 4 logical CPUs used)
}
}
\references{
Brazzale, A. R. and Küchenhoff, H. and Krügel, S. and Hartl, W.
  (2017) \emph{Nonparametric change point estimation for survival
  distributions with a partially constant hazard rate.}
}
\author{
Stefanie Krügel \email{stefanie.kruegel@gmail.com}
}
