% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MH_status.R
\name{MH_status}
\alias{MH_status}
\title{Mental Health status detection in North American Healthcare Administrative Databases}
\usage{
MH_status(inputdata, n_MHH, n_MHP, t_MH, ICD_MH)
}
\arguments{
\item{inputdata}{a dataframe including columns: ClientID,  VisitDate,  Diagnostic_H, and Diagnostic_P}

\item{n_MHH}{minimum number of potential mental health related hospital visits}

\item{n_MHP}{minimum number of potential mental health related medical service physician visits}

\item{t_MH}{maximum time lag (in days) between all hospital visits and all medical service physician visits}

\item{ICD_MH}{plausible list of Mental Health status diagnostic codes}
}
\value{
a dataframe matrix with  Clients' ID, earliest date of Mental Health, latest date of Mental Health, and Mental Health status
}
\description{
Mental Health status is detected in North American Healthcare Administrative Databases  using clinician's parameters of interest such as minimum number of hospital visits, minimum number of physician services, time lag between them and plausible ICD diagnostics.
}
\examples{
data(SampleRWD)
myexample <- SampleRWD[,c(1:4)]
SampleMH_1 <- MH_status(myexample,
n_MHH=1, n_MHP=1, t_MH=60,
ICD_MH=c("F060","F063","F064", "F067"))
head(SampleMH_1)

}
\references{
Khan S. (2017). Concurrent mental and substance use disorders in Canada. Health reports, 28(8), 3–8, Ottawa, ON, Canada, PMID: 29044442. https://pubmed.ncbi.nlm.nih.gov/29044442/
Canadian Institute for Health Information. (2022). Canadian coding standards for version 2022 ICD-10-CA and CCI. Canadian Institute for Health Information. Ottawa, Ontario, Canada. https://www.cihi.ca/en/version-2022-icd-10-cacci-classifications-canadian-coding-standards-and-related-products
Centers for Disease Control and Prevention. (2024). International classification of diseases, tenth revision, clinical modification (ICD-10-CM) 2024. National Center for Health Statistics. Atlanta, GA, United States. https://www.cdc.gov/nchs/icd/icd-10-cm/index.html
Casillas, S. M., Scholl, L., Mustaquim, D., & Vivolo-Kantor, A. (2022). Analysis of trends and usage of ICD-10-CM discharge diagnosis codes for poisonings by fentanyl, tramadol, and other synthetic narcotics in emergency department data. Addictive Behaviors Reports, 16, 100464. Atlanta, GA, USA. https://doi.org/10.1016/j.abrep.2022.100464
}
