% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CompK_CP.R
\name{CompK_CP}
\alias{CompK_CP}
\title{Compute Capital Stock in Chinese Provinces}
\usage{
CompK_CP(
  prv,
  startyr = 1993,
  yr = NULL,
  invest = NULL,
  InvestPrice = NULL,
  depr = NULL,
  delta = 0.096,
  bt = 1992
)
}
\arguments{
\item{prv}{a province name, a scalar character. It's Chinese phonetic alphabets.}

\item{startyr}{a numeric scalar. When use the method by Chen (2020), \code{delta} is
used before \code{startyr}, and after \code{startyr} depreciation in data \code{asset} is used.}

\item{yr}{a numeric vector about years. If you only need capital stock before 2017,
you can use its default \code{NULL}. If you need to compute capital stocks in other
years (for example 2018,2019), you can set, for example, \code{yr = c(2018,2019)}.}

\item{invest}{a numeric vector about investment, its length equal the length of
\code{yr}, and its units is 100 million in current price.}

\item{InvestPrice}{a numeric vector about price indices of investment,
its length equal the length of \code{yr}, and it is a fixed base index
with equaling 1 in \code{bt}.}

\item{depr}{a numeric vector about depreciation,its length equal the length of \code{yr},
and its units is 100 million in current price.}

\item{delta}{a rate of depreciation, a scalar number.}

\item{bt}{a scalar number, such as 2000. It means computing capital stock with its price equal
1 in \code{bt}}
}
\value{
The function return a data.frame, and its 1st column is province, 2nd column
is year, 3rd column is capital stock, 4th column is the price index of investment.
}
\description{
This function compute capital stock of provinces in China using the method by Chen (2020).
}
\note{
The parameter \code{InvestPrice} is a fixed base index with equaling 1 in 1952 by default.
However, we often only get a price indices of investment with equaling 1
in last year. You can use \code{data(asset)} to get \code{InvestPrice}
in any year (before 2017) with equaling 1 in 1952. So, it is easy then.
}
\references{
Chen, Pu, 2020, Compute capital stocks of provinces in China (In Chinese).
}
