% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convenience.R
\name{prob_association_m}
\alias{prob_association_m}
\title{Calculate probability of association for one mode of inheritance}
\usage{
prob_association_m(y, min_ac = 1L, prior_prob_association = 0.01, ...)
}
\arguments{
\item{y}{Logical vector of case (\code{TRUE}) control (\code{FALSE}) status.}

\item{min_ac}{Integer vector with a length equalling the number of individuals or length \code{1} (in which case the given value is used for all individuals) giving the minimum number of alleles at pathogenic variant sites each individual requires in order to classify as having a `pathogenic allele configuration'. Thus, this parameter encodes the mode of inheritance. For instance, setting this parameter to \code{1} corresponds to dominant inheritance. If there are differences in ploidy between individuals in the locus, it is necessary to set it on an sample level basis - e.g. to ensure sex is accounted for if the locus lies on the X chromosome.}

\item{prior_prob_association}{The prior probability of association.}

\item{...}{Other arguments to pass to \code{\link{log_BF}}.}
}
\value{
Probability value.
}
\description{
Equivalent to \code{\link{prob_association}} where the prior probability of one mode of inheritance is 1. This function is faster, as it only calls \code{\link{bevimed_m}} once.
}
\seealso{
\code{\link{log_BF}}, \code{\link{prob_association}}, \code{\link{bevimed_m}}
}
