% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jbd_coordinates_precision.R
\name{jbd_coordinates_precision}
\alias{jbd_coordinates_precision}
\title{Flags coordinates for imprecision}
\usage{
jbd_coordinates_precision(
  data,
  lat = "decimalLatitude",
  lon = "decimalLongitude",
  ndec = NULL,
  quieter = FALSE
)
}
\arguments{
\item{data}{A data frame or tibble. Occurrence records as input.}

\item{lat}{Character. The name of the column to use as latitude. Default = "decimalLatitude".}

\item{lon}{Character. The name of the column to use as longitude. Default = "decimalLongitude".}

\item{ndec}{Numeric. The number of decimal places to flag in decimal degrees. For example,
argument value of 2 would flag occurrences with nothing in the hundredths place (0.0x).}

\item{quieter}{Logical. If TRUE, the functino will run a little quieter. Default = FALSE.}
}
\value{
Returns the input data frame with a new column, .rou, where FALSE indicates occurrences
that failed the test.
}
\description{
This function flags occurrences where BOTH latitude and longitude values are rounded. This
contrasts with the original function, bdc::bdc_coordinates_precision() that will flag
occurrences where only one of latitude OR longitude are rounded. The BeeBDC approach saves
occurrences that may have had terminal zeros rounded in one coordinate column.
}
\examples{
beesRaw_out <- jbd_coordinates_precision(
  data = BeeBDC::beesRaw,
  lon = "decimalLongitude",
  lat = "decimalLatitude",
    # number of decimals to be tested
  ndec = 2
)
table(beesRaw_out$.rou, useNA = "always")
}
