## Note SRS 5/11/2022: Moved all the data from ~/data to
## test data - changing files to save to ~/testdata
## in the .rds format. Leaving previous code saving
## data with usethis::usedata() commented out for now

# 
#  Generate an example JAGS probit fitted model
#
 library(R2jags)

#data("sim_data_interactive")
sim_data_interactive <- readRDS(file.path(TESTDATA_DIR, "sim_data_interactive.rds"))
  

## formatting the data for jags
datjags <- as.list(sim_data_interactive)
datjags$N <- length(datjags$Y)

## creating jags model
model <- function()  {
  
  for(i in 1:N){
    Y[i] ~ dnorm(mu[i], sigma)  ## Bernoulli distribution of y_i
    
    mu[i] <- b[1] + 
      b[2] * X1[i] + 
      b[3] * X2[i] +
      b[4] * X1[i] * X2[i]
    
  }
  
  for(j in 1:4){
    b[j] ~ dnorm(0, 0.001) ## Use a coefficient vector for simplicity
  }
  
  sigma ~ dexp(1)
  
}

params <- c("b")
inits1 <- list("b" = rep(0, 4))
inits2 <- list("b" = rep(0, 4))
inits <- list(inits1, inits2)

## fitting the model with R2jags
set.seed(123)
jags_interactive <- R2jags::jags(data = datjags, inits = inits, 
                                 parameters.to.save = params, n.chains = 2,
                                 n.iter = 2000, n.burnin = 1000,
                                 model.file = model)

#usethis::use_data(jags_interactive, overwrite = TRUE)
#saveRDS(jags_interactive, "tests/testdata/jags_interactive.rds")
saveRDS(jags_interactive, file.path(TESTDATA_DIR, "jags_interactive.rds"))



