% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BayesDLMfMRI.R
\name{plot.fMRI_single_evidence}
\alias{plot.fMRI_single_evidence}
\title{plot.fMRI_single_evidence}
\usage{
\method{plot}{fMRI_single_evidence}(x, overlay, index, index2 = NULL, ...)
}
\arguments{
\item{x}{is the returned value of any of the ffdEvidence* functions.}

\item{overlay}{MNI image used to plot posterior probability maps.}

\item{index}{the element of \code{res} to be plotted.}

\item{index2}{the element of \code{res} to be plotted, only used if needed.}

\item{...}{additional parameters passed to the \code{ortho2} function.}
}
\description{
Plot function
}
\details{
Plot function
}
\examples{
\dontrun{
fMRI.data  <- get_example_fMRI_data()
data("covariates", package="BayesDLMfMRI")
data("ffd", package="BayesDLMfMRI") # used for overlay.
res <- ffdEvidenceFETS(ffdc = fMRI.data,
                   covariates = Covariates,
                   m0 = 0, Cova = 100, delta = 0.95,
                   S0 = 1, n0 = 1, Nsimu1 = 100, Cutpos1 = 30,
                   r1 = 1, Test = "LTT", Ncores = 15)
plot(res, overlay=ffd, index=1, col.y = heat.colors(50), 
     ycolorbar = TRUE, ybreaks = seq(0.95, 1, by = 0.001))
}
}
