% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot.R
\name{bv_ggplot}
\alias{bv_ggplot}
\alias{bv_ggplot.default}
\alias{bv_ggplot.bvar_chains}
\alias{bv_ggplot.bvar}
\alias{bv_ggplot.bvar_irf}
\alias{bv_ggplot.bvar_fcast}
\title{Quick ggplot2 plots for Bayesian VARs}
\usage{
bv_ggplot(x, ...)

\method{bv_ggplot}{default}(x, ...)

\method{bv_ggplot}{bvar_chains}(x, ...)

\method{bv_ggplot}{bvar}(
  x,
  type = c("trace", "density"),
  vars = NULL,
  vars_response = NULL,
  vars_impulse = NULL,
  orientation = c("horizontal", "vertical"),
  chains = list(),
  ...
)

\method{bv_ggplot}{bvar_irf}(x, vars_response = NULL, vars_impulse = NULL, col = "#737373", ...)

\method{bv_ggplot}{bvar_fcast}(x, vars = NULL, col = "#737373", t_back = 1L, ...)
}
\arguments{
\item{x}{A \code{bvar} or derived object to turn into a dataframe.}

\item{...}{Not used.}

\item{type}{A string with the type (trace or density) of plot desired.}

\item{vars}{Character vector used to select variables. Elements are matched
to hyperparameters or coefficients. Coefficients may be matched based on
the dependent variable (by providing the name or position) or the
explanatory variables (by providing the name and the desired lag). See the
example section for a demonstration. Defaults to \code{NULL}, i.e. all
hyperparameters.}

\item{vars_response}{Optional character or integer vectors used
to select coefficents. Dependent variables are specified with
\emph{vars_response}, explanatory ones with \emph{vars_impulse}. Defaults to
\code{NULL}, indicating that no coefficients will be processed.
draws.}

\item{vars_impulse}{Optional character or integer vectors used
to select coefficents. Dependent variables are specified with
\emph{vars_response}, explanatory ones with \emph{vars_impulse}. Defaults to
\code{NULL}, indicating that no coefficients will be processed.
draws.}

\item{orientation}{A string indicating the desired orientation of trace or
density plots}

\item{chains}{List of \code{bvar} objects. Contents of multiple runs are
added to the output, in order to help in assessing covergence.}

\item{col}{Character vector. Colour(s) of the lines delineating credible
intervals. Single values will be recycled if necessary. Recycled HEX color
codes are varied in transparency if not provided (e.g. "#737373FF"). Lines
can be bypassed by setting this to \code{"transparent"}.}

\item{t_back}{Integer scalar. Whether to include actual datapoints in the
tidied forecast.}
}
\value{
Returns a \code{ggplot} object with a basic structure.
}
\description{
Function to quickly plot outputs from \code{bvar} and derived objects.
Supported plots include traces and densities, forecasts, and impulse
response functions. For more flexible plots one may use the outputs of
\code{\link{tidy.bvar}} and \code{\link{augment.bvar}}.
}
\examples{
# Access a subset of the fred_qd dataset
data <- fred_qd[, c("CPIAUCSL", "UNRATE", "FEDFUNDS")]
# Transform it to be stationary
data <- fred_transform(data, codes = c(5, 5, 1), lag = 4)

# Estimate a BVAR using one lag, default settings and very few draws
x <- bvar(data, lags = 1, n_draw = 1000L, n_burn = 200L, verbose = FALSE)

# Plot the outputs - alternatively use ggplot() with fortify()
bv_ggplot(x)
bv_ggplot(irf(x))
bv_ggplot(predict(x))
}
