% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy.R
\name{tidy.bvar}
\alias{tidy.bvar}
\alias{tidy.bvar_coefs}
\alias{tidy.bvar_fcast}
\alias{tidy.bvar_irf}
\title{Tidy BVAR outputs and convert into a tibble}
\usage{
\method{tidy}{bvar}(
  x,
  vars = NULL,
  vars_response = NULL,
  vars_impulse = NULL,
  chains = list(),
  ...
)

\method{tidy}{bvar_coefs}(x, ...)

\method{tidy}{bvar_fcast}(x, t_back = 0L, ...)

\method{tidy}{bvar_irf}(x, ...)
}
\arguments{
\item{x}{A \code{bvar} or derived object to turn into a dataframe.}

\item{vars}{Character vector used to select variables. Elements are matched
to hyperparameters or coefficients. Coefficients may be matched based on
the dependent variable (by providing the name or position) or the
explanatory variables (by providing the name and the desired lag). See the
example section for a demonstration. Defaults to \code{NULL}, i.e. all
hyperparameters.}

\item{vars_impulse, vars_response}{Optional character or integer vectors used
to select coefficents. Dependent variables are specified with
\emph{vars_response}, explanatory ones with \emph{vars_impulse}. Defaults to
\code{NULL}, indicating that no coefficients will be processed.
draws.}

\item{chains}{List of \code{bvar} objects. Contents of multiple runs are
added to the output, in order to help in assessing covergence.}

\item{...}{Not used.}

\item{t_back}{Integer scalar. Whether to include actual datapoints in the
tidied forecast.}
}
\value{
Returns a tidy \code{\link[tibble]{tibble}} with relevant
information for further processing.
}
\description{
Turn the outputs of a Bayesian VAR (see \code{\link[BVAR]{bvar}}) into a
a tidy tibble. Methods are available for \code{bvar} objects (will yield a
subset of coefficient and/or hyperparameter draws), \code{bvar_coefs} objects
(with the coefficients and their quantiles) \code{bvar_fcast} objects (with
predictions, their quantiles and optionally real datapoints), and
\code{bvar_irf} objects (with impulse responses).
}
\examples{
\donttest{
# Access a subset of the fred_qd dataset
data <- fred_qd[, c("CPIAUCSL", "UNRATE", "FEDFUNDS")]
# Transform it to be stationary
data <- fred_transform(data, codes = c(5, 5, 1), lag = 4)

# Estimate a BVAR using one lag, default settings and very few draws
x <- bvar(data, lags = 1, n_draw = 1000L, n_burn = 200L, verbose = FALSE)

# Create tidy tibbles from the outputs
tidy(x)
tidy(irf(x))
tidy(predict(x))
}
}
