% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svdbips.R
\name{svdbips}
\alias{svdbips}
\title{SVD for bipartitioned matrix x}
\usage{
svdbips(x, K, H, r)
}
\arguments{
\item{x}{a \code{p} times \code{q} matrix}

\item{K}{is a row vector which contains the numbers pk, k=1,...,kx, of the partition of x with kx row blocks : \code{sum(pk)=p}}

\item{H}{is a row vector which contains the numbers qh, h=1,...,ky, of the partition of x with ky column blocks : sum(qh)=q}

\item{r}{The number of wanted successive solutions}
}
\value{
A \code{list} with following components:
\item{u}{a \code{p} times \code{r} matrix of kx row blocks uk (pk x r); uk'*uk = Identity.}
\item{v}{a \code{q} times \code{r} matrix of \code{ky} row blocks \code{vi (qi x r)} of axes in \code{Rqi} relative to \code{yi; vi^prime*vi = Identity}}
\item{s}{a \code{kx} times \code{ky} times \code{r} array; with r fixed, each matrix contains kxky values \eqn{(u_h'*x_{kh}*v_k)^2}, the partial (squared) singular values relative to xkh.}
}
\description{
SVD for bipartitioned matrix x. SIMULTANEOUS SOLUTIONS. ("simultaneous svdbip")
}
\details{
One set of r solutions is calculated by maximizing \eqn{\sum_i \sum_k \sum_h
(u_k[,i]'*x_{kh}*v_h[,i])^2}, with kx+ky orthonormality constraints (for
each uk and each vh).  For each fixed r value, the solution is totally
new (does'nt consist to complete a previous calculus of one set of r-1
solutions).  \code{rmax=min([min(K),min(H)])}.  When r=1, it is svdbip (thus
it is svdcp when r=1 and kx=1).
Convergence of algorithm may be not global. So the below proposed
initialisation of the algorithm may be not very suitable for some data
sets.  Several different random initialisations with normed vectors
might be considered and the best result then choosen....
}
\examples{
x <- matrix(runif(200),10,20)
s1 <- svdbip(x,c(3,4,3),c(5,5,10),2);sum(sum(sum(s1$s2)))
ss <- svdbips(x,c(3,4,3),c(5,5,10),2);sum(sum(sum(ss$s2)))

}
\references{
Lafosse R. & Ten Berge J. A simultaneous CONCOR method for the analysis of two partitioned matrices. submitted.
}
\author{
\enc{Lafosse, R.}{R. Lafosse}
}
