% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concorgmcano.R
\name{concorgmcano}
\alias{concorgmcano}
\title{Canonical analysis of subsets Yj with subsets Xi}
\usage{
concorgmcano(x, px, y, py, r)
}
\arguments{
\item{x}{are the \code{n} times \code{p} and \code{n} times \code{q} matrices of \code{p} and \code{q} centered column}

\item{px}{The row vector which contains the numbers pi, i=1,...,kx, of the kx subsets xi of x : \eqn{\sum_i p_i}=sum(px)=p. px is the partition vector of x}

\item{y}{See \code{x}}

\item{py}{The partition vector of y. A row vector containing the numbers \code{qi} for \code{i = 1,...,ky} of the \code{ky} subsets \code{yi} of \code{y : sum(qi)=sum(py)=q}.}

\item{r}{The number of wanted successive solutions rmax <= min(min(px),min(py),n)}
}
\value{
A \code{list} with following components:
\item{cx}{is a \code{n.kx} times  \code{r} matrix of kx row blocks cxi (n x r). Each row block contains r partial canonical components}
\item{cy}{is a  \code{n.ky} times  \code{r} matrix of ky row blocks cyj (n x r). Each row block contains r partial canonical components}
\item{rho2}{is a  \code{kx} time  \code{ky} tims  \code{r} array; for a fixed solution k, \code{rho2[,,k]} contains kxky squared correlations \eqn{rho2(cx[n*(i-1)+1:n*i,k],cy[n*(j-1)+1:n*j,k])}, simultaneously calculated between all the yj with all the xi}
}
\description{
Canonical analysis of subsets Yj with subsets Xi. Relative valuations by squared correlations of the proximities of subsets Xi with subsets Yj. SUCCESSIVE SOLUTIONS
}
\details{
For the first solution, \eqn{sum_i sum_j \mbox{rho2}(cx_i[,1],cy_j[,1])} is the optimized
criterion. The other solutions are calculated from the same criterion, but with
orthogonalities for having two by two zero correlated the canonical components defined for
each xi, and also for those defined for each yj.  Each solution associates kx canonical
components to ky canonical components.  When kx =1 (px=p), take \code{concorcano} function
This function uses the concorgm function
}
\examples{
x <- matrix(runif(50),10,5);y <- matrix(runif(90),10,9)
x <- scale(x);y <- scale(y)
cc <- concorgmcano(x,c(2,3),y,c(3,2,4),2)
cc$rho2[1,1,]

}
\references{
Kissita G., Analyse canonique generalisee avec tableau de reference generalisee. Thesis, Ceremade Paris 9 Dauphine (2003).
}
\author{
\enc{Lafosse, R.}{R. Lafosse}
}
