% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_data.R
\name{simulate_data}
\alias{simulate_data}
\title{Simulate Data}
\usage{
simulate_data(parameters, N, N_0, N_1, rho_o = 0)
}
\arguments{
\item{parameters}{A list containing the true values of the parameters: mu_star,mu_0,mu_1,gamma_0,gamma_1,rho_0,delta_0,rho_1,delta_1 and rho_01}

\item{N}{Number of events}

\item{N_0}{Number of forecasters in the control group}

\item{N_1}{Number of forecasters in the treatment group}

\item{rho_o}{The level of dependence between event outcomes. (Default: the events are independent conditional on the model parameter values. This sets \code{rho_ = 0.0})}
}
\value{
List containing the simulated data.
The elements of the list are as follows.
\itemize{
\item Outcomes: Vector containing binary values that indicate the outcome of each event. The j-th entry is equal to 1 if the j-th event occurs and equal to 0 otherwise.
\item Control: List of vectors (one for each event) containing probability predictions made by the forecasters in the control group.
\item Treatment: List of vectors (one for each event) containing probability predictions made by the forecasters in the treatment group.
}
}
\description{
This function allows the user to generate synthetic data of two groups (control and treatment) of forecasters making probability predictions of binary events.
The function is mostly useful for testing and illustration purposes.
}
\details{
See \code{\link{complete_summary}} for a description of the model parameters.
Not all combinations of parameters are possible.
In particular, the covariance parameters gamma and rho are dependent on each other and must result in a positive semi-definite covariance matrix for the outcomes and predictions.
To find a feasible set of parameters, we recommend users to experiment: begin with the desired levels of mu, gamma, and delta, and values of rho close to zero, and then increase rho until data can be generated without errors.
}
\examples{
\donttest{
simulate_data(list(mu_star = -0.8,mu_0 = -0.5,mu_1 = 0.2,gamma_0 = 0.1,gamma_1 = 0.3,
rho_0 = 0.05,delta_0 = 0.1,rho_1 = 0.2, delta_1 = 0.3,rho_01 = 0.05), 300,100,100)
}


}
\seealso{
\code{\link{estimate_BIN}}, \code{\link{complete_summary}}
}
