% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_batch_request.R
\name{create_table_operation}
\alias{create_table_operation}
\alias{create_batch_transaction}
\alias{do_batch_transaction}
\alias{do_batch_transaction.batch_transaction}
\title{Batch transactions for table storage}
\usage{
create_table_operation(
  endpoint,
  path,
  options = list(),
  headers = list(),
  body = NULL,
  metadata = c("none", "minimal", "full"),
  http_verb = c("GET", "PUT", "POST", "PATCH", "DELETE", "HEAD")
)

create_batch_transaction(endpoint, operations)

do_batch_transaction(transaction, ...)

\method{do_batch_transaction}{batch_transaction}(
  transaction,
  batch_status_handler = c("warn", "stop", "message", "pass"),
  num_retries = 10,
  ...
)
}
\arguments{
\item{endpoint}{A table storage endpoint, of class \code{table_endpoint}.}

\item{path}{The path component of the operation.}

\item{options}{A named list giving the query parameters for the operation.}

\item{headers}{A named list giving any additional HTTP headers to send to the host. AzureCosmosR will handle authentication details, so you don't have to specify these here.}

\item{body}{The request body for a PUT/POST/PATCH operation.}

\item{metadata}{The level of ODATA metadata to include in the response.}

\item{http_verb}{The HTTP verb (method) for the operation.}

\item{operations}{A list of individual table operation objects, each of class \code{table_operation}.}

\item{transaction}{For \code{do_batch_transaction}, an object of class \code{batch_transaction}.}

\item{...}{Arguments passed to lower-level functions.}

\item{batch_status_handler}{For \code{do_batch_transaction}, what to do if one or more of the batch operations fails. The default is to signal a warning and return a list of response objects, from which the details of the failure(s) can be determined. Set this to "pass" to ignore the failure.}

\item{num_retries}{The number of times to retry the call, if the response is a HTTP error 429 (too many requests). The Cosmos DB endpoint tends to be aggressive at rate-limiting requests, to maintain the desired level of latency. This will generally not affect calls to an endpoint provided by a storage account.}
}
\value{
\code{create_table_operation} returns an object of class \code{table_operation}.

Assuming the batch transaction did not fail due to rate-limiting, \code{do_batch_transaction} returns a list of objects of class \code{table_operation_response}, representing the results of each individual operation. Each object contains elements named \code{status}, \code{headers} and \code{body} containing the respective parts of the response. Note that the number of returned objects may be smaller than the number of operations in the batch, if the transaction failed.
}
\description{
Batch transactions for table storage
}
\details{
Table storage supports batch transactions on entities that are in the same table and belong to the same partition group. Batch transactions are also known as \emph{entity group transactions}.

You can use \code{create_table_operation} to produce an object corresponding to a single table storage operation, such as inserting, deleting or updating an entity. Multiple such objects can then be passed to \code{create_batch_transaction}, which bundles them into a single atomic transaction. Call \code{do_batch_transaction} to send the transaction to the endpoint.

Note that batch transactions are subject to some limitations imposed by the REST API:
\itemize{
\item All entities subject to operations as part of the transaction must have the same \code{PartitionKey} value.
\item An entity can appear only once in the transaction, and only one operation may be performed against it.
\item The transaction can include at most 100 entities, and its total payload may be no more than 4 MB in size.
}
}
\examples{
\dontrun{

endp <- table_endpoint("https://mycosmosdb.table.cosmos.azure.com:443", key="mykey")
tab <- create_storage_table(endp, "mytable")

## a simple batch insert
ir <- subset(iris, Species == "setosa")

# property names must be valid C# variable names
names(ir) <- sub("\\\\.", "_", names(ir))

# create the PartitionKey and RowKey properties
ir$PartitionKey <- ir$Species
ir$RowKey <- sprintf("\%03d", seq_len(nrow(ir)))

# generate the array of insert operations: 1 per row
ops <- lapply(seq_len(nrow(ir)), function(i)
    create_table_operation(endp, "mytable", body=ir[i, ], http_verb="POST")))

# create a batch transaction and send it to the endpoint
bat <- create_batch_transaction(endp, ops)
do_batch_transaction(bat)

}
}
\seealso{
\link{import_table_entities}, which uses (multiple) batch transactions under the hood

\href{https://docs.microsoft.com/en-us/rest/api/storageservices/performing-entity-group-transactions}{Performing entity group transactions}
}
