% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/subset.R
\docType{methods}
\name{subset}
\alias{subset}
\alias{[,MCMC-method}
\alias{[,PhasesMCMC-method}
\title{Extract or Replace Parts of an Object}
\usage{
\S4method{[}{MCMC}(x, i, j, ..., drop = FALSE)

\S4method{[}{PhasesMCMC}(x, i, j, k, drop = FALSE)
}
\arguments{
\item{x}{An object from which to extract element(s) or in which to replace
element(s).}

\item{i, j, k}{Indices specifying elements to extract or replace.}

\item{...}{Currently not used.}

\item{drop}{A \code{\link{logical}} scalar: should the result be coerced to
the lowest possible dimension? This only works for extracting elements,
not for the replacement.}
}
\value{
A subsetted object.
}
\description{
Operators acting on objects to extract or replace parts.
}
\examples{
## Events
(eve <- as_events(mcmc_events, calendar = CE(), iteration = 1))

eve[1:1000, ] # Select the first 1000 iterations
eve[, 1:2]    # Select the first 2 events

cbind2(eve[, 1:2], eve[, 3:4]) # Combine two MCMC objects
sort(eve, decreasing = TRUE)   # Sort events in descending order

## Phases
(pha <- as_phases(mcmc_phases, start = c(1, 3), calendar = CE(), iteration = 1))

pha[1:1000, , ]          # Select the first 1000 iterations
pha[, 1, , drop = FALSE] # Select the first phase
}
\seealso{
Other mutators: 
\code{\link{bind}},
\code{\link{data.frame}},
\code{\link{names}()},
\code{\link{sort}()},
\code{\link{sort.list}()}
}
\author{
N. Frerebeau
}
\concept{mutators}
