% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linearlinear_analysis.R
\name{linear.linear}
\alias{linear.linear}
\title{Analysis: Linear-Linear}
\usage{
linear.linear(
  trat,
  resp,
  middle = 1,
  CI = FALSE,
  bootstrap.samples = 1000,
  sig.level = 0.05,
  error = "SE",
  ylab = "Dependent",
  xlab = "Independent",
  theme = theme_classic(),
  point = "all",
  width.bar = NA,
  legend.position = "top",
  textsize = 12,
  pointsize = 4.5,
  linesize = 0.8,
  linetype = 1,
  pointshape = 21,
  fillshape = "gray",
  colorline = "black",
  round = NA,
  xname.formula = "x",
  yname.formula = "y",
  comment = NA,
  fontfamily = "sans",
  print.on = TRUE
)
}
\arguments{
\item{trat}{Numeric vector with dependent variable.}

\item{resp}{Numeric vector with independent variable.}

\item{middle}{A scalar in [0,1]. This represents the range that the change-point can occur in. 0 means the change-point must occur at the middle of the range of x-values. 1 means that the change-point can occur anywhere along the range of the x-values.}

\item{CI}{Whether or not a bootstrap confidence interval should be calculated. Defaults to FALSE because the interval takes a non-trivial amount of time to calculate}

\item{bootstrap.samples}{The number of bootstrap samples to take when calculating the CI.}

\item{sig.level}{What significance level to use for the confidence intervals.}

\item{error}{Error bar (It can be SE - \emph{default}, SD or FALSE)}

\item{ylab}{Variable response name (Accepts the \emph{expression}() function)}

\item{xlab}{treatments name (Accepts the \emph{expression}() function)}

\item{theme}{ggplot2 theme (\emph{default} is theme_classic())}

\item{point}{defines whether you want to plot all points ("all") or only the mean ("mean")}

\item{width.bar}{Bar width}

\item{legend.position}{legend position (\emph{default} is "top")}

\item{textsize}{Font size}

\item{pointsize}{shape size}

\item{linesize}{line size}

\item{linetype}{line type}

\item{pointshape}{format point (default is 21)}

\item{fillshape}{Fill shape}

\item{colorline}{Color lines}

\item{round}{round equation}

\item{xname.formula}{Name of x in the equation}

\item{yname.formula}{Name of y in the equation}

\item{comment}{Add text after equation}

\item{fontfamily}{Font family}

\item{print.on}{Print output}
}
\value{
The function returns a list containing the coefficients and their respective values of p; statistical parameters such as AIC, BIC, pseudo-R2, RMSE (root mean square error); breakpoint and the graph using ggplot2 with the equation automatically.
}
\description{
This function performs linear linear regression analysis.
}
\details{
The linear-linear model is defined by:
First curve:
\deqn{y = \beta_0 + \beta_1 \times x (x < breakpoint)}

Second curve:
\deqn{y = \beta_0 + \beta_1 \times breakpoint + w \times x (x > breakpoint)}
}
\examples{
library(AgroReg)
data("granada")
attach(granada)
linear.linear(time,WL)
}
\references{
Chiu, G. S., R. Lockhart, and R. Routledge. 2006. Bent-cable regression theory and applications. Journal of the American Statistical Association 101:542-553.

Toms, J. D., and M. L. Lesperance. 2003. Piecewise regression: a tool for identifying ecological thresholds. Ecology 84:2034-2041.
}
\seealso{
\link{quadratic.plateau}, \link{linear.plateau}
}
\author{
Model imported from the SiZer package

Gabriel Danilo Shimizu

Leandro Simoes Azeredo Goncalves
}
