% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataSimulation.R
\name{simDat19}
\alias{simDat19}
\title{Simulate data for Chapter 19: Occupancy model}
\usage{
simDat19(
  nSites = 150,
  nVisits = 3,
  alpha.occ = 0,
  beta.occ = 2,
  alpha.p = 0,
  beta.p = -3
)
}
\arguments{
\item{nSites}{Number of sites}

\item{nVisits}{Number of replicate visits per site}

\item{alpha.occ}{Occupancy intercept}

\item{beta.occ}{Occupancy slope}

\item{alpha.p}{Detection probability intercept}

\item{beta.p}{Detection probability slope}
}
\value{
A list of simulated data and parameters.
  \item{nSites}{Number of sites}
  \item{nVisits}{Number replicate visits per site}
  \item{alpha.occ}{Occupancy intercept}
  \item{beta.occ}{Occupancy slope}
  \item{alpha.p}{Detection probability intercept}
  \item{beta.p}{Detection probability slope}
  \item{humidity}{Humidity covariate}
  \item{occ.prob}{Probability of occupancy at each site}
  \item{z}{True occupancy state at each site}
  \item{true_Nz}{True number of occupied sites}
  \item{lp}{Linear predictor for detection}
  \item{p}{Probability of detection at each site}
  \item{y}{Simulated detection/non-detection data}
  \item{obs_Nz}{Observed number of occupied sites}
}
\description{
Simulate detection/nondetection data of Chiltern gentians
}
\examples{
str(dat <- simDat19())             # Implicit default arguments
str(dat <- simDat19(nSites = 150, nVisits = 3, alpha.occ = 0, beta.occ = 2,
  alpha.p = 0, beta.p = -3))       # Explicit default arguments
str(dat <- simDat19(nSites = 500)) # More sites
str(dat <- simDat19(nVisits = 1))  # Single-visit data
str(dat <- simDat19(nVisits = 20)) # 20 visits, will yield cumulative detection prob of about 1
str(dat <- simDat19(alpha.occ = 2))# Much higher occupancy
str(dat <- simDat19(beta.occ = 0)) # No effect of humidity on occupancy
str(dat <- simDat19(beta.p = 3))   # Positive effect of humidity on detection
str(dat <- simDat19(beta.p = 0))   # No effect of humidity on detection

}
\author{
Marc Kéry
}
