% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores_mh_aseba.R
\name{compute_mh_p_abcl__critic_tscore}
\alias{compute_mh_p_abcl__critic_tscore}
\title{Compute "Adult Behavior Checklist [Parent] (Critical items): T-score"}
\usage{
compute_mh_p_abcl__critic_tscore(
  data,
  data_norm = NULL,
  name = "mh_p_abcl__critic_tscore",
  col_age = "mh_p_abcl__cg2__age_001",
  col_sex = "mh_p_abcl__cg2_sex",
  max_na = 1,
  exclude = c("777", "999"),
  combine = TRUE
)
}
\arguments{
\item{data}{tbl. Data frame containing the columns to be summarized.}

\item{data_norm}{tbl. Data frame containing the norm (T-score) values.
see \code{\link[=ss_tscore]{ss_tscore()}}.}

\item{name}{character. Name of the summary score column.}

\item{col_age}{character, name of the age column. see \code{\link[=ss_tscore]{ss_tscore()}}.}

\item{col_sex}{character, name of the sex column. see \code{\link[=ss_tscore]{ss_tscore()}}.}

\item{max_na}{numeric, positive whole number. Number of missing items
allowed. \code{NULL} means no limit.}

\item{exclude}{character vector. Values to be excluded from the summary score.}

\item{combine}{logical. If \code{TRUE} (default), the summary score is
is appended as a new column to the input data frame. If \code{FALSE}, the
summary score is returned as a separate one-column data frame.}
}
\value{
tbl. see \code{combine}.
}
\description{
Computes the summary score \code{mh_p_abcl__critic_tscore}
Adult Behavior Checklist [Parent] (Critical items): T-score
\itemize{
\item \emph{Summarized variables:}
\itemize{
\item \code{mh_p_abcl__rule_001}
\item \code{mh_p_abcl__attn__adhd_002}
\item \code{mh_p_abcl__tho_001}
\item \code{mh_p_abcl__othpr__adhd_001}
\item \code{mh_p_abcl__anxdep__dep_001}
\item \code{mh_p_abcl__aggr__antsoc_003}
\item \code{mh_p_abcl__tho__dep_001}
\item \code{mh_p_abcl__othpr__antsoc_001}
\item \code{mh_p_abcl__tho_002}
\item \code{mh_p_abcl__aggr_001}
\item \code{mh_p_abcl__aggr__antsoc_006}
\item \code{mh_p_abcl__tho_003}
\item \code{mh_p_abcl__tho_004}
\item \code{mh_p_abcl__tho_006}
\item \code{mh_p_abcl__rule_002}
\item \code{mh_p_abcl__tho__dep_002}
\item \code{mh_p_abcl__rule__antsoc_007}
\item \code{mh_p_abcl__aggr__antsoc_008}
\item \code{mh_p_abcl__anxdep__dep_004}
}
\item \emph{Excluded values:}
\itemize{
\item 777
\item 999
}
\item \emph{Validation criterion:} maximally 1 of 19 items missing
}
}
\examples{
\dontrun{
compute_mh_p_abcl__critic_tscore(data) |>
  select(
    any_of(c("mh_p_abcl__critic_tscore", vars_mh_p_abcl__critic))
  )
}
}
\seealso{
\code{\link[=compute_mh_p_abcl__critic_nm]{compute_mh_p_abcl__critic_nm()}}
}
