% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny_onesampt.R
\name{shiny_onesampt}
\alias{shiny_onesampt}
\title{Shiny App to Demonstrate One-Sample Student's t-Test}
\usage{
shiny_onesampt()
}
\value{
The outcomes are presented in several tabs.
    \item{Population}{contains the density plots of the population and
    rug plots of the sample units randomly drawn from the population.
    It also includes the population parameter values chosen by the user.}
    \item{Sample}{contains the dot plot and box plot of the sample drawn
    randomly from the population and rug plot of the sample units.
    It also includes the mean and standard deviation of the random sample.}
    \item{Test Statistic}{presents the plot showing the mean difference
    between the sample mean and hypothesised mean and corresponding 95\% confidence intervals (CI).
    The tab also contains the distribution of the test statistic \code{t}
    with the observed value of the test statistic and probabilities under the given value of the Type 1 error}
    \item{Summary}{includes the summary of the sampled data and outcomes
    from the one-sample Student's t-test. Different sections are:
    (1) Hypothesis, highlighting the null and alternative hypothesis;
    (2) Sample, tabulating the full sampled data;
    (3) Summary Statistics, summarising the summary information of the sample;
    (4) Test Statistic, presenting the outputs from the one-sample Student's t-test.
    (5) Confidence Interval, highlighting the mean difference and corresponding 95\% confidence intervals (CI).}
}
\description{
An interactive Shiny app to demonstrate one-sample Student's t-test.
}
\details{
The interactive Shiny app demonstrates the principles of the hypothesis testing of means
    in a one-sample design where the population variance is unknown.
    The true population parameters are provided by the user.
    The user changes the hypothesised population mean and other features and explores
    how Student's t-test compares the hypothesised mean
    with the mean of the sample randomly drawn from the population.

    The left panel includes the user inputs for \strong{Simulation Features}, \strong{Population Parameters},
    \strong{Sample Characteristics}, and \strong{Distribution Function}.
    To use the app at first instance, just click the \code{Update} button.
    To alter the input values, edit the text box or move the point on the slider and
    explore the changes in different tabs (see below).

    To obtain identical outcomes in a separate run of the app,
    set a common seed value at the bottom of the left panel and click \code{Update}.
    All subsequent updates will produce identical results provided other inputs are identical.
    The seed value is ignored when the option \code{check the box to update instantly} is selected.
}
\note{
\url{https://shiny.abdn.ac.uk/Stats/apps/}
}
\examples{
if(interactive()){
    library(ggplot2)
    library(shiny)
    library(ABACUS)
    # Run shiny app
    shiny_onesampt()
}

}
\seealso{
Function in base R for normal distribution and t distribution including
         \code{\link{dnorm}}, \code{\link{pnorm}}, \code{\link{qnorm}}, \code{\link{rnorm}},
         \code{\link{dt}}, \code{\link{pt}}, \code{\link{qt}}, \code{\link{rt}}
         The app \code{\link{shiny_onesampz}} performs the hypothesis testing of mean
         when the population variance is unknown.
}
\author{
Mintu Nath
}
