/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.Puntal;

public class MultiPoint
extends GeometryCollection
implements Puntal {
    private static final long serialVersionUID = -8048474874175355449L;

    public MultiPoint(Point[] points, PrecisionModel precisionModel, int SRID) {
        super(points, new GeometryFactory(precisionModel, SRID));
    }

    public MultiPoint(Point[] points, GeometryFactory factory) {
        super(points, factory);
    }

    @Override
    public int getDimension() {
        return 0;
    }

    @Override
    public int getBoundaryDimension() {
        return -1;
    }

    @Override
    public String getGeometryType() {
        return "MultiPoint";
    }

    @Override
    public Geometry getBoundary() {
        return this.getFactory().createGeometryCollection();
    }

    @Override
    public MultiPoint reverse() {
        return (MultiPoint)super.reverse();
    }

    @Override
    protected MultiPoint reverseInternal() {
        Point[] points = new Point[this.geometries.length];
        for (int i = 0; i < points.length; ++i) {
            points[i] = (Point)this.geometries[i].copy();
        }
        return new MultiPoint(points, this.factory);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean equalsExact(Geometry other, double tolerance) {
        if (!this.isEquivalentClass(other)) {
            return false;
        }
        return super.equalsExact(other, tolerance);
    }

    protected Coordinate getCoordinate(int n) {
        return ((Point)this.geometries[n]).getCoordinate();
    }

    @Override
    protected MultiPoint copyInternal() {
        Point[] points = new Point[this.geometries.length];
        for (int i = 0; i < points.length; ++i) {
            points[i] = (Point)this.geometries[i].copy();
        }
        return new MultiPoint(points, this.factory);
    }

    @Override
    protected int getTypeCode() {
        return 1;
    }
}

