/*
 * Decompiled with CFR 0.152.
 */
package scala.math;

import java.math.MathContext;
import scala.ScalaObject;
import scala.collection.mutable.ArrayOps;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.math.BigInt$;

public final class BigDecimal$
implements ScalaObject {
    public static final BigDecimal$ MODULE$;
    private final int minCached;
    private final int maxCached;
    private final MathContext defaultMathContext;
    private final BigDecimal MinLong;
    private final BigDecimal MaxLong;
    private BigDecimal[] cache;
    public volatile int bitmap$0;

    static {
        new BigDecimal$();
    }

    private int minCached() {
        return this.minCached;
    }

    private int maxCached() {
        return this.maxCached;
    }

    public MathContext defaultMathContext() {
        return this.defaultMathContext;
    }

    public BigDecimal MinLong() {
        return this.MinLong;
    }

    public BigDecimal MaxLong() {
        return this.MaxLong;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private BigDecimal[] cache() {
        if ((this.bitmap$0 & 1) != 0) return this.cache;
        synchronized (this) {
            if ((this.bitmap$0 & 1) == 0) {
                this.cache = new BigDecimal[this.maxCached() - this.minCached() + 1];
                this.bitmap$0 |= 1;
            }
            return this.cache;
        }
    }

    public BigDecimal valueOf(double d) {
        java.math.BigDecimal bigDecimal = java.math.BigDecimal.valueOf(d);
        MathContext mathContext = this.defaultMathContext;
        return new BigDecimal(bigDecimal, mathContext);
    }

    public BigDecimal valueOf(double d, MathContext mc) {
        java.math.BigDecimal bigDecimal = java.math.BigDecimal.valueOf(d);
        return new BigDecimal(bigDecimal, mc);
    }

    public BigDecimal apply(int i) {
        return this.apply(i, this.defaultMathContext);
    }

    /*
     * Enabled aggressive block sorting
     */
    public BigDecimal apply(int i, MathContext mc) {
        BigDecimal bigDecimal;
        MathContext mathContext = mc;
        MathContext mathContext2 = this.defaultMathContext;
        if (!(mathContext != null ? !((Object)mathContext).equals(mathContext2) : mathContext2 != null)) {
            if (this.minCached() <= i && i <= this.maxCached()) {
                int offset = i - this.minCached();
                BigDecimal n = this.cache()[offset];
                if (n == null) {
                    this.cache()[offset] = n = new BigDecimal(java.math.BigDecimal.valueOf(i), mc);
                }
                bigDecimal = n;
                return bigDecimal;
            }
        }
        bigDecimal = new BigDecimal(java.math.BigDecimal.valueOf(i), mc);
        return bigDecimal;
    }

    public BigDecimal apply(long l) {
        BigDecimal bigDecimal;
        if ((long)this.minCached() <= l && l <= (long)this.maxCached()) {
            int n = (int)l;
            bigDecimal = this.apply(n, this.defaultMathContext);
        } else {
            bigDecimal = new BigDecimal(java.math.BigDecimal.valueOf(l), this.defaultMathContext);
        }
        return bigDecimal;
    }

    public BigDecimal apply(long l, MathContext mc) {
        return new BigDecimal(new java.math.BigDecimal(l, mc), mc);
    }

    public BigDecimal apply(long unscaledVal, int scale) {
        BigInt bigInt = BigInt$.MODULE$.apply(unscaledVal);
        MathContext mathContext = this.defaultMathContext;
        return new BigDecimal(new java.math.BigDecimal(bigInt.bigInteger(), scale, mathContext), mathContext);
    }

    public BigDecimal apply(long unscaledVal, int scale, MathContext mc) {
        BigInt bigInt = BigInt$.MODULE$.apply(unscaledVal);
        return new BigDecimal(new java.math.BigDecimal(bigInt.bigInteger(), scale, mc), mc);
    }

    public BigDecimal apply(double d) {
        MathContext mathContext = this.defaultMathContext;
        return new BigDecimal(new java.math.BigDecimal(Double.toString(d), mathContext), mathContext);
    }

    public BigDecimal apply(double d, MathContext mc) {
        return new BigDecimal(new java.math.BigDecimal(Double.toString(d), mc), mc);
    }

    public BigDecimal apply(char[] x) {
        MathContext mathContext = this.defaultMathContext;
        return new BigDecimal(new java.math.BigDecimal(new ArrayOps.ofChar(x).mkString(), mathContext), mathContext);
    }

    public BigDecimal apply(char[] x, MathContext mc) {
        return new BigDecimal(new java.math.BigDecimal(new ArrayOps.ofChar(x).mkString(), mc), mc);
    }

    public BigDecimal apply(String x) {
        MathContext mathContext = this.defaultMathContext;
        return new BigDecimal(new java.math.BigDecimal(x, mathContext), mathContext);
    }

    public BigDecimal apply(String x, MathContext mc) {
        return new BigDecimal(new java.math.BigDecimal(x, mc), mc);
    }

    public BigDecimal apply(BigInt x) {
        MathContext mathContext = this.defaultMathContext;
        return new BigDecimal(new java.math.BigDecimal(x.bigInteger(), mathContext), mathContext);
    }

    public BigDecimal apply(BigInt x, MathContext mc) {
        return new BigDecimal(new java.math.BigDecimal(x.bigInteger(), mc), mc);
    }

    public BigDecimal apply(BigInt unscaledVal, int scale) {
        MathContext mathContext = this.defaultMathContext;
        return new BigDecimal(new java.math.BigDecimal(unscaledVal.bigInteger(), scale, mathContext), mathContext);
    }

    public BigDecimal apply(BigInt unscaledVal, int scale, MathContext mc) {
        return new BigDecimal(new java.math.BigDecimal(unscaledVal.bigInteger(), scale, mc), mc);
    }

    public BigDecimal apply(java.math.BigDecimal bd) {
        MathContext mathContext = this.defaultMathContext;
        return new BigDecimal(bd, mathContext);
    }

    public BigDecimal apply(java.math.BigDecimal bd, MathContext mc) {
        return new BigDecimal(bd, mc);
    }

    public BigDecimal int2bigDecimal(int i) {
        return this.apply(i, this.defaultMathContext);
    }

    public BigDecimal long2bigDecimal(long l) {
        return this.apply(l);
    }

    public BigDecimal double2bigDecimal(double d) {
        MathContext mathContext = this.defaultMathContext;
        java.math.BigDecimal bigDecimal = java.math.BigDecimal.valueOf(d);
        return new BigDecimal(bigDecimal, mathContext);
    }

    private BigDecimal$() {
        MODULE$ = this;
        this.minCached = -512;
        this.maxCached = 512;
        this.defaultMathContext = MathContext.UNLIMITED;
        this.MinLong = new BigDecimal(java.math.BigDecimal.valueOf(Long.MIN_VALUE), this.defaultMathContext());
        this.MaxLong = new BigDecimal(java.math.BigDecimal.valueOf(Long.MAX_VALUE), this.defaultMathContext());
    }
}

