/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Properties;
import kafka.consumer.ConsumerConfig$;
import kafka.message.Message$;
import kafka.message.MessageSet$;
import kafka.server.KafkaConfig$;
import kafka.utils.Utils$;
import kafka.utils.VerifiableProperties;
import kafka.utils.ZKConfig;
import scala.Predef$;
import scala.ScalaObject;
import scala.Tuple2$mcII$sp;
import scala.Tuple2$mcLL$sp;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\t\u0005e\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\u0004\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\u0003\b\u0011\u0005%aQ\"\u0001\u0006\u000b\u0005-!\u0011!B;uS2\u001c\u0018BA\u0007\u000b\u0005!Q6jQ8oM&<\u0007CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"aC*dC2\fwJ\u00196fGRD\u0001\"\u0006\u0001\u0003\u0006\u0004%\tAF\u0001\u0006aJ|\u0007o]\u000b\u0002/A\u0011\u0011\u0002G\u0005\u00033)\u0011ACV3sS\u001aL\u0017M\u00197f!J|\u0007/\u001a:uS\u0016\u001c\b\u0002C\u000e\u0001\u0005\u0003\u0005\u000b\u0011B\f\u0002\rA\u0014x\u000e]:!\u0011\u0015i\u0002\u0001\"\u0003\u001f\u0003\u0019a\u0014N\\5u}Q\u0011q$\t\t\u0003A\u0001i\u0011A\u0001\u0005\u0006+q\u0001\ra\u0006\u0005\u0006;\u0001!\ta\t\u000b\u0003?\u0011BQ!\n\u0012A\u0002\u0019\nQb\u001c:jO&t\u0017\r\u001c)s_B\u001c\bCA\u0014-\u001b\u0005A#BA\u0015+\u0003\u0011)H/\u001b7\u000b\u0003-\nAA[1wC&\u0011Q\u0006\u000b\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\b\"B\u0018\u0001\t\u0013\u0001\u0014!G4fi2{wMU3uK:$\u0018n\u001c8US6,W*\u001b7mSN$\u0012!\r\t\u0003\u001fIJ!a\r\t\u0003\t1{gn\u001a\u0005\bk\u0001\u0011\r\u0011\"\u00017\u0003!\u0011'o\\6fe&#W#A\u001c\u0011\u0005=A\u0014BA\u001d\u0011\u0005\rIe\u000e\u001e\u0005\u0007w\u0001\u0001\u000b\u0011B\u001c\u0002\u0013\t\u0014xn[3s\u0013\u0012\u0004\u0003bB\u001f\u0001\u0005\u0004%\tAN\u0001\u0010[\u0016\u001c8/Y4f\u001b\u0006D()\u001f;fg\"1q\b\u0001Q\u0001\n]\n\u0001#\\3tg\u0006<W-T1y\u0005f$Xm\u001d\u0011\t\u000f\u0005\u0003!\u0019!C\u0001m\u0005\tb.^7OKR<xN]6UQJ,\u0017\rZ:\t\r\r\u0003\u0001\u0015!\u00038\u0003IqW/\u001c(fi^|'o\u001b+ie\u0016\fGm\u001d\u0011\t\u000f\u0015\u0003!\u0019!C\u0001m\u0005aa.^7J_RC'/Z1eg\"1q\t\u0001Q\u0001\n]\nQB\\;n\u0013>$\u0006N]3bIN\u0004\u0003bB%\u0001\u0005\u0004%\tAN\u0001\u0012E\u0006\u001c7n\u001a:pk:$G\u000b\u001b:fC\u0012\u001c\bBB&\u0001A\u0003%q'\u0001\ncC\u000e\\wM]8v]\u0012$\u0006N]3bIN\u0004\u0003bB'\u0001\u0005\u0004%\tAN\u0001\u0012cV,W/\u001a3NCb\u0014V-];fgR\u001c\bBB(\u0001A\u0003%q'\u0001\nrk\u0016,X\rZ'bqJ+\u0017/^3tiN\u0004\u0003bB)\u0001\u0005\u0004%\tAN\u0001\u0005a>\u0014H\u000f\u0003\u0004T\u0001\u0001\u0006IaN\u0001\u0006a>\u0014H\u000f\t\u0005\b+\u0002\u0011\r\u0011\"\u0001W\u0003!Awn\u001d;OC6,W#A,\u0011\u0005a[fBA\bZ\u0013\tQ\u0006#\u0001\u0004Qe\u0016$WMZ\u0005\u00039v\u0013aa\u0015;sS:<'B\u0001.\u0011\u0011\u0019y\u0006\u0001)A\u0005/\u0006I\u0001n\\:u\u001d\u0006lW\r\t\u0005\bC\u0002\u0011\r\u0011\"\u0001W\u0003I\tGM^3si&\u001cX\r\u001a%pgRt\u0015-\\3\t\r\r\u0004\u0001\u0015!\u0003X\u0003M\tGM^3si&\u001cX\r\u001a%pgRt\u0015-\\3!\u0011\u001d)\u0007A1A\u0005\u0002Y\na\"\u00193wKJ$\u0018n]3e!>\u0014H\u000f\u0003\u0004h\u0001\u0001\u0006IaN\u0001\u0010C\u00124XM\u001d;jg\u0016$\u0007k\u001c:uA!9\u0011\u000e\u0001b\u0001\n\u00031\u0014!F:pG.,GoU3oI\n+hMZ3s\u0005f$Xm\u001d\u0005\u0007W\u0002\u0001\u000b\u0011B\u001c\u0002-M|7m[3u'\u0016tGMQ;gM\u0016\u0014()\u001f;fg\u0002Bq!\u001c\u0001C\u0002\u0013\u0005a'\u0001\rt_\u000e\\W\r\u001e*fG\u0016Lg/\u001a\"vM\u001a,'OQ=uKNDaa\u001c\u0001!\u0002\u00139\u0014!G:pG.,GOU3dK&4XMQ;gM\u0016\u0014()\u001f;fg\u0002Bq!\u001d\u0001C\u0002\u0013\u0005a'A\u000bt_\u000e\\W\r\u001e*fcV,7\u000f^'bq\nKH/Z:\t\rM\u0004\u0001\u0015!\u00038\u0003Y\u0019xnY6fiJ+\u0017/^3ti6\u000b\u0007PQ=uKN\u0004\u0003bB;\u0001\u0005\u0004%\tAN\u0001\u000e]Vl\u0007+\u0019:uSRLwN\\:\t\r]\u0004\u0001\u0015!\u00038\u00039qW/\u001c)beRLG/[8og\u0002Bq!\u001f\u0001C\u0002\u0013\u0005!0A\u0004m_\u001e$\u0015N]:\u0016\u0003m\u00042\u0001`@X\u001b\u0005i(B\u0001@\u0011\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0004\u0003\u0003i(aA*fc\"9\u0011Q\u0001\u0001!\u0002\u0013Y\u0018\u0001\u00037pO\u0012K'o\u001d\u0011\t\u0011\u0005%\u0001A1A\u0005\u0002Y\nq\u0002\\8h'\u0016<W.\u001a8u\u0005f$Xm\u001d\u0005\b\u0003\u001b\u0001\u0001\u0015!\u00038\u0003AawnZ*fO6,g\u000e\u001e\"zi\u0016\u001c\b\u0005\u0003\u0005\u0002\u0012\u0001\u0011\r\u0011\"\u00017\u00031awn\u001a*pY2Du.\u001e:t\u0011\u001d\t)\u0002\u0001Q\u0001\n]\nQ\u0002\\8h%>dG\u000eS8veN\u0004\u0003\"CA\r\u0001\t\u0007I\u0011AA\u000e\u0003Yawn\u001a*fi\u0016tG/[8o)&lW-T5mY&\u001cX#A\u0019\t\u000f\u0005}\u0001\u0001)A\u0005c\u00059Bn\\4SKR,g\u000e^5p]RKW.Z'jY2L7\u000f\t\u0005\n\u0003G\u0001!\u0019!C\u0001\u00037\t\u0011\u0003\\8h%\u0016$XM\u001c;j_:\u0014\u0015\u0010^3t\u0011\u001d\t9\u0003\u0001Q\u0001\nE\n!\u0003\\8h%\u0016$XM\u001c;j_:\u0014\u0015\u0010^3tA!I\u00111\u0006\u0001C\u0002\u0013\u0005\u00111D\u0001\u0015Y><7\t\\3b]V\u0004\u0018J\u001c;feZ\fG.T:\t\u000f\u0005=\u0002\u0001)A\u0005c\u0005)Bn\\4DY\u0016\fg.\u001e9J]R,'O^1m\u001bN\u0004\u0003\u0002CA\u001a\u0001\t\u0007I\u0011\u0001,\u0002!1|wm\u00117fC:,\b\u000fU8mS\u000eL\bbBA\u001c\u0001\u0001\u0006IaV\u0001\u0012Y><7\t\\3b]V\u0004\bk\u001c7jGf\u0004\u0003\u0002CA\u001e\u0001\t\u0007I\u0011\u0001\u001c\u0002#1|wm\u00117fC:,'\u000f\u00165sK\u0006$7\u000fC\u0004\u0002@\u0001\u0001\u000b\u0011B\u001c\u0002%1|wm\u00117fC:,'\u000f\u00165sK\u0006$7\u000f\t\u0005\n\u0003\u0007\u0002!\u0019!C\u0001\u0003\u000b\nQ\u0004\\8h\u00072,\u0017M\\3s\u0013>l\u0015\r\u001f\"zi\u0016\u001c\b+\u001a:TK\u000e|g\u000eZ\u000b\u0003\u0003\u000f\u00022aDA%\u0013\r\tY\u0005\u0005\u0002\u0007\t>,(\r\\3\t\u0011\u0005=\u0003\u0001)A\u0005\u0003\u000f\na\u0004\\8h\u00072,\u0017M\\3s\u0013>l\u0015\r\u001f\"zi\u0016\u001c\b+\u001a:TK\u000e|g\u000e\u001a\u0011\t\u0013\u0005M\u0003A1A\u0005\u0002\u0005m\u0011A\u00077pO\u000ecW-\u00198fe\u0012+G-\u001e9f\u0005V4g-\u001a:TSj,\u0007bBA,\u0001\u0001\u0006I!M\u0001\u001cY><7\t\\3b]\u0016\u0014H)\u001a3va\u0016\u0014UO\u001a4feNK'0\u001a\u0011\t\u0011\u0005m\u0003A1A\u0005\u0002Y\na\u0003\\8h\u00072,\u0017M\\3s\u0013>\u0014UO\u001a4feNK'0\u001a\u0005\b\u0003?\u0002\u0001\u0015!\u00038\u0003]awnZ\"mK\u0006tWM]%p\u0005V4g-\u001a:TSj,\u0007\u0005C\u0005\u0002d\u0001\u0011\r\u0011\"\u0001\u0002F\u0005\u0001Cn\\4DY\u0016\fg.\u001a:EK\u0012,\b/\u001a\"vM\u001a,'\u000fT8bI\u001a\u000b7\r^8s\u0011!\t9\u0007\u0001Q\u0001\n\u0005\u001d\u0013!\t7pO\u000ecW-\u00198fe\u0012+G-\u001e9f\u0005V4g-\u001a:M_\u0006$g)Y2u_J\u0004\u0003\"CA6\u0001\t\u0007I\u0011AA\u000e\u0003MawnZ\"mK\u0006tWM\u001d\"bG.|gMZ't\u0011\u001d\ty\u0007\u0001Q\u0001\nE\nA\u0003\\8h\u00072,\u0017M\\3s\u0005\u0006\u001c7n\u001c4g\u001bN\u0004\u0003\"CA:\u0001\t\u0007I\u0011AA#\u0003]awnZ\"mK\u0006tWM]'j]\u000ecW-\u00198SCRLw\u000e\u0003\u0005\u0002x\u0001\u0001\u000b\u0011BA$\u0003aawnZ\"mK\u0006tWM]'j]\u000ecW-\u00198SCRLw\u000e\t\u0005\n\u0003w\u0002!\u0019!C\u0001\u0003{\n\u0001\u0003\\8h\u00072,\u0017M\\3s\u000b:\f'\r\\3\u0016\u0005\u0005}\u0004cA\b\u0002\u0002&\u0019\u00111\u0011\t\u0003\u000f\t{w\u000e\\3b]\"A\u0011q\u0011\u0001!\u0002\u0013\ty(A\tm_\u001e\u001cE.Z1oKJ,e.\u00192mK\u0002B\u0011\"a#\u0001\u0005\u0004%\t!a\u0007\u000271|wm\u00117fC:,'\u000fR3mKR,'+\u001a;f]RLwN\\'t\u0011\u001d\ty\t\u0001Q\u0001\nE\nA\u0004\\8h\u00072,\u0017M\\3s\t\u0016dW\r^3SKR,g\u000e^5p]6\u001b\b\u0005\u0003\u0005\u0002\u0014\u0002\u0011\r\u0011\"\u00017\u0003QawnZ%oI\u0016D8+\u001b>f\u001b\u0006D()\u001f;fg\"9\u0011q\u0013\u0001!\u0002\u00139\u0014!\u00067pO&sG-\u001a=TSj,W*\u0019=CsR,7\u000f\t\u0005\t\u00037\u0003!\u0019!C\u0001m\u0005)Bn\\4J]\u0012,\u00070\u00138uKJ4\u0018\r\u001c\"zi\u0016\u001c\bbBAP\u0001\u0001\u0006IaN\u0001\u0017Y><\u0017J\u001c3fq&sG/\u001a:wC2\u0014\u0015\u0010^3tA!I\u00111\u0015\u0001C\u0002\u0013\u0005\u00111D\u0001\u0019Y><g\t\\;tQ&sG/\u001a:wC2lUm]:bO\u0016\u001c\bbBAT\u0001\u0001\u0006I!M\u0001\u001aY><g\t\\;tQ&sG/\u001a:wC2lUm]:bO\u0016\u001c\b\u0005C\u0005\u0002,\u0002\u0011\r\u0011\"\u0001\u0002\u001c\u0005\u0001Bn\\4EK2,G/\u001a#fY\u0006LXj\u001d\u0005\b\u0003_\u0003\u0001\u0015!\u00032\u0003Eawn\u001a#fY\u0016$X\rR3mCfl5\u000f\t\u0005\n\u0003g\u0003!\u0019!C\u0001\u00037\t1\u0004\\8h\r2,8\u000f[*dQ\u0016$W\u000f\\3s\u0013:$XM\u001d<bY6\u001b\bbBA\\\u0001\u0001\u0006I!M\u0001\u001dY><g\t\\;tQN\u001b\u0007.\u001a3vY\u0016\u0014\u0018J\u001c;feZ\fG.T:!\u0011%\tY\f\u0001b\u0001\n\u0003\tY\"\u0001\nm_\u001e4E.^:i\u0013:$XM\u001d<bY6\u001b\bbBA`\u0001\u0001\u0006I!M\u0001\u0014Y><g\t\\;tQ&sG/\u001a:wC2l5\u000f\t\u0005\t\u0003\u0007\u0004!\u0019!C\u0001m\u0005\u0011Cn\\4GYV\u001c\bn\u00144gg\u0016$8\t[3dWB|\u0017N\u001c;J]R,'O^1m\u001bNDq!a2\u0001A\u0003%q'A\u0012m_\u001e4E.^:i\u001f\u001a47/\u001a;DQ\u0016\u001c7\u000e]8j]RLe\u000e^3sm\u0006dWj\u001d\u0011\t\u0013\u0005-\u0007A1A\u0005\u0002\u0005u\u0014AF1vi>\u001c%/Z1uKR{\u0007/[2t\u000b:\f'\r\\3\t\u0011\u0005=\u0007\u0001)A\u0005\u0003\u007f\nq#Y;u_\u000e\u0013X-\u0019;f)>\u0004\u0018nY:F]\u0006\u0014G.\u001a\u0011\t\u0011\u0005M\u0007A1A\u0005\u0002Y\n\u0011dY8oiJ|G\u000e\\3s'>\u001c7.\u001a;US6,w.\u001e;Ng\"9\u0011q\u001b\u0001!\u0002\u00139\u0014AG2p]R\u0014x\u000e\u001c7feN{7m[3u)&lWm\\;u\u001bN\u0004\u0003\u0002CAn\u0001\t\u0007I\u0011\u0001\u001c\u00025\r|g\u000e\u001e:pY2,'/T3tg\u0006<W-U;fk\u0016\u001c\u0016N_3\t\u000f\u0005}\u0007\u0001)A\u0005o\u0005Y2m\u001c8ue>dG.\u001a:NKN\u001c\u0018mZ3Rk\u0016,XmU5{K\u0002B\u0001\"a9\u0001\u0005\u0004%\tAN\u0001\u0019I\u00164\u0017-\u001e7u%\u0016\u0004H.[2bi&|gNR1di>\u0014\bbBAt\u0001\u0001\u0006IaN\u0001\u001aI\u00164\u0017-\u001e7u%\u0016\u0004H.[2bi&|gNR1di>\u0014\b\u0005C\u0005\u0002l\u0002\u0011\r\u0011\"\u0001\u0002\u001c\u0005\u0019\"/\u001a9mS\u000e\fG*Y4US6,W*\u0019=Ng\"9\u0011q\u001e\u0001!\u0002\u0013\t\u0014\u0001\u0006:fa2L7-\u0019'bORKW.Z'bq6\u001b\b\u0005C\u0005\u0002t\u0002\u0011\r\u0011\"\u0001\u0002\u001c\u0005)\"/\u001a9mS\u000e\fG*Y4NCblUm]:bO\u0016\u001c\bbBA|\u0001\u0001\u0006I!M\u0001\u0017e\u0016\u0004H.[2b\u0019\u0006<W*\u0019=NKN\u001c\u0018mZ3tA!A\u00111 \u0001C\u0002\u0013\u0005a'\u0001\fsKBd\u0017nY1T_\u000e\\W\r\u001e+j[\u0016|W\u000f^'t\u0011\u001d\ty\u0010\u0001Q\u0001\n]\nqC]3qY&\u001c\u0017mU8dW\u0016$H+[7f_V$Xj\u001d\u0011\t\u0011\t\r\u0001A1A\u0005\u0002Y\nqD]3qY&\u001c\u0017mU8dW\u0016$(+Z2fSZ,')\u001e4gKJ\u0014\u0015\u0010^3t\u0011\u001d\u00119\u0001\u0001Q\u0001\n]\n\u0001E]3qY&\u001c\u0017mU8dW\u0016$(+Z2fSZ,')\u001e4gKJ\u0014\u0015\u0010^3tA!A!1\u0002\u0001C\u0002\u0013\u0005a'\u0001\u000bsKBd\u0017nY1GKR\u001c\u0007.T1y\u0005f$Xm\u001d\u0005\b\u0005\u001f\u0001\u0001\u0015!\u00038\u0003U\u0011X\r\u001d7jG\u00064U\r^2i\u001b\u0006D()\u001f;fg\u0002B\u0001Ba\u0005\u0001\u0005\u0004%\tAN\u0001\u0016e\u0016\u0004H.[2b\r\u0016$8\r[,bSRl\u0015\r_'t\u0011\u001d\u00119\u0002\u0001Q\u0001\n]\naC]3qY&\u001c\u0017MR3uG\"<\u0016-\u001b;NCbl5\u000f\t\u0005\t\u00057\u0001!\u0019!C\u0001m\u0005!\"/\u001a9mS\u000e\fg)\u001a;dQ6KgNQ=uKNDqAa\b\u0001A\u0003%q'A\u000bsKBd\u0017nY1GKR\u001c\u0007.T5o\u0005f$Xm\u001d\u0011\t\u0011\t\r\u0002A1A\u0005\u0002Y\n!C\\;n%\u0016\u0004H.[2b\r\u0016$8\r[3sg\"9!q\u0005\u0001!\u0002\u00139\u0014a\u00058v[J+\u0007\u000f\\5dC\u001a+Go\u00195feN\u0004\u0003\"\u0003B\u0016\u0001\t\u0007I\u0011AA\u000e\u0003!\u0012X\r\u001d7jG\u0006D\u0015n\u001a5XCR,'/\\1sW\u000eCWmY6q_&tG/\u00138uKJ4\u0018\r\\'t\u0011\u001d\u0011y\u0003\u0001Q\u0001\nE\n\u0011F]3qY&\u001c\u0017\rS5hQ^\u000bG/\u001a:nCJ\\7\t[3dWB|\u0017N\u001c;J]R,'O^1m\u001bN\u0004\u0003\u0002\u0003B\u001a\u0001\t\u0007I\u0011\u0001\u001c\u0002G\u0019,Go\u00195QkJ<\u0017\r^8ssB+(oZ3J]R,'O^1m%\u0016\fX/Z:ug\"9!q\u0007\u0001!\u0002\u00139\u0014\u0001\n4fi\u000eD\u0007+\u001e:hCR|'/\u001f)ve\u001e,\u0017J\u001c;feZ\fGNU3rk\u0016\u001cHo\u001d\u0011\t\u0011\tm\u0002A1A\u0005\u0002Y\na\u0005\u001d:pIV\u001cWM\u001d)ve\u001e\fGo\u001c:z!V\u0014x-Z%oi\u0016\u0014h/\u00197SKF,Xm\u001d;t\u0011\u001d\u0011y\u0004\u0001Q\u0001\n]\nq\u0005\u001d:pIV\u001cWM\u001d)ve\u001e\fGo\u001c:z!V\u0014x-Z%oi\u0016\u0014h/\u00197SKF,Xm\u001d;tA!I!1\t\u0001C\u0002\u0013\u0005\u0011QP\u0001\u001aCV$x\u000eT3bI\u0016\u0014(+\u001a2bY\u0006t7-Z#oC\ndW\r\u0003\u0005\u0003H\u0001\u0001\u000b\u0011BA@\u0003i\tW\u000f^8MK\u0006$WM\u001d*fE\u0006d\u0017M\\2f\u000b:\f'\r\\3!\u0011!\u0011Y\u0005\u0001b\u0001\n\u00031\u0014A\t7fC\u0012,'/S7cC2\fgnY3QKJ\u0014%o\\6feB+'oY3oi\u0006<W\rC\u0004\u0003P\u0001\u0001\u000b\u0011B\u001c\u0002G1,\u0017\rZ3s\u00136\u0014\u0017\r\\1oG\u0016\u0004VM\u001d\"s_.,'\u000fU3sG\u0016tG/Y4fA!A!1\u000b\u0001C\u0002\u0013\u0005a'A\u0012mK\u0006$WM]%nE\u0006d\u0017M\\2f\u0007\",7m[%oi\u0016\u0014h/\u00197TK\u000e|g\u000eZ:\t\u000f\t]\u0003\u0001)A\u0005o\u0005!C.Z1eKJLUNY1mC:\u001cWm\u00115fG.Le\u000e^3sm\u0006d7+Z2p]\u0012\u001c\b\u0005\u0003\u0005\u0003\\\u0001\u0011\r\u0011\"\u00017\u0003q\u0019wN\u001c;s_2dW\rZ*ikR$wn\u001e8NCb\u0014V\r\u001e:jKNDqAa\u0018\u0001A\u0003%q'A\u000fd_:$(o\u001c7mK\u0012\u001c\u0006.\u001e;e_^tW*\u0019=SKR\u0014\u0018.Z:!\u0011!\u0011\u0019\u0007\u0001b\u0001\n\u00031\u0014\u0001I2p]R\u0014x\u000e\u001c7fINCW\u000f\u001e3po:\u0014V\r\u001e:z\u0005\u0006\u001c7n\u001c4g\u001bNDqAa\u001a\u0001A\u0003%q'A\u0011d_:$(o\u001c7mK\u0012\u001c\u0006.\u001e;e_^t'+\u001a;ss\n\u000b7m[8gM6\u001b\b\u0005C\u0005\u0003l\u0001\u0011\r\u0011\"\u0001\u0002~\u0005A2m\u001c8ue>dG.\u001a3TQV$Hm\\<o\u000b:\f'\r\\3\t\u0011\t=\u0004\u0001)A\u0005\u0003\u007f\n\u0011dY8oiJ|G\u000e\\3e'\",H\u000fZ8x]\u0016s\u0017M\u00197fA!A!1\u000f\u0001C\u0002\u0013\u0005a'A\u000bpM\u001a\u001cX\r^'fi\u0006$\u0017\r^1NCb\u001c\u0016N_3\t\u000f\t]\u0004\u0001)A\u0005o\u00051rN\u001a4tKRlU\r^1eCR\fW*\u0019=TSj,\u0007\u0005C\u0005\u0003|\u0001\u0011\r\u0011\"\u0001\u0002~\u0005\tB-\u001a7fi\u0016$v\u000e]5d\u000b:\f'\r\\3\t\u0011\t}\u0004\u0001)A\u0005\u0003\u007f\n!\u0003Z3mKR,Gk\u001c9jG\u0016s\u0017M\u00197fA\u0001")
public class KafkaConfig
extends ZKConfig
implements ScalaObject {
    private final VerifiableProperties props;
    private final int brokerId;
    private final int messageMaxBytes;
    private final int numNetworkThreads;
    private final int numIoThreads;
    private final int backgroundThreads;
    private final int queuedMaxRequests;
    private final int port;
    private final String hostName;
    private final String advertisedHostName;
    private final int advertisedPort;
    private final int socketSendBufferBytes;
    private final int socketReceiveBufferBytes;
    private final int socketRequestMaxBytes;
    private final int numPartitions;
    private final Seq<String> logDirs;
    private final int logSegmentBytes;
    private final int logRollHours;
    private final long logRetentionTimeMillis;
    private final long logRetentionBytes;
    private final long logCleanupIntervalMs;
    private final String logCleanupPolicy;
    private final int logCleanerThreads;
    private final double logCleanerIoMaxBytesPerSecond;
    private final long logCleanerDedupeBufferSize;
    private final int logCleanerIoBufferSize;
    private final double logCleanerDedupeBufferLoadFactor;
    private final long logCleanerBackoffMs;
    private final double logCleanerMinCleanRatio;
    private final boolean logCleanerEnable;
    private final long logCleanerDeleteRetentionMs;
    private final int logIndexSizeMaxBytes;
    private final int logIndexIntervalBytes;
    private final long logFlushIntervalMessages;
    private final long logDeleteDelayMs;
    private final long logFlushSchedulerIntervalMs;
    private final long logFlushIntervalMs;
    private final int logFlushOffsetCheckpointIntervalMs;
    private final boolean autoCreateTopicsEnable;
    private final int controllerSocketTimeoutMs;
    private final int controllerMessageQueueSize;
    private final int defaultReplicationFactor;
    private final long replicaLagTimeMaxMs;
    private final long replicaLagMaxMessages;
    private final int replicaSocketTimeoutMs;
    private final int replicaSocketReceiveBufferBytes;
    private final int replicaFetchMaxBytes;
    private final int replicaFetchWaitMaxMs;
    private final int replicaFetchMinBytes;
    private final int numReplicaFetchers;
    private final long replicaHighWatermarkCheckpointIntervalMs;
    private final int fetchPurgatoryPurgeIntervalRequests;
    private final int producerPurgatoryPurgeIntervalRequests;
    private final boolean autoLeaderRebalanceEnable;
    private final int leaderImbalancePerBrokerPercentage;
    private final int leaderImbalanceCheckIntervalSeconds;
    private final int controlledShutdownMaxRetries;
    private final int controlledShutdownRetryBackoffMs;
    private final boolean controlledShutdownEnable;
    private final int offsetMetadataMaxSize;
    private final boolean deleteTopicEnable;

    public VerifiableProperties props() {
        return this.props;
    }

    public KafkaConfig(Properties originalProps) {
        this(new VerifiableProperties(originalProps));
        this.props().verify();
    }

    private long getLogRetentionTimeMillis() {
        long millisInMinute = 60000L;
        long millisInHour = 60L * millisInMinute;
        return this.props().containsKey("log.retention.minutes") ? millisInMinute * (long)this.props().getIntInRange("log.retention.minutes", new Tuple2$mcII$sp(1, Integer.MAX_VALUE)) : millisInHour * (long)this.props().getIntInRange("log.retention.hours", 168, new Tuple2$mcII$sp(1, Integer.MAX_VALUE));
    }

    public int brokerId() {
        return this.brokerId;
    }

    public int messageMaxBytes() {
        return this.messageMaxBytes;
    }

    public int numNetworkThreads() {
        return this.numNetworkThreads;
    }

    public int numIoThreads() {
        return this.numIoThreads;
    }

    public int backgroundThreads() {
        return this.backgroundThreads;
    }

    public int queuedMaxRequests() {
        return this.queuedMaxRequests;
    }

    public int port() {
        return this.port;
    }

    public String hostName() {
        return this.hostName;
    }

    public String advertisedHostName() {
        return this.advertisedHostName;
    }

    public int advertisedPort() {
        return this.advertisedPort;
    }

    public int socketSendBufferBytes() {
        return this.socketSendBufferBytes;
    }

    public int socketReceiveBufferBytes() {
        return this.socketReceiveBufferBytes;
    }

    public int socketRequestMaxBytes() {
        return this.socketRequestMaxBytes;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public Seq<String> logDirs() {
        return this.logDirs;
    }

    public int logSegmentBytes() {
        return this.logSegmentBytes;
    }

    public int logRollHours() {
        return this.logRollHours;
    }

    public long logRetentionTimeMillis() {
        return this.logRetentionTimeMillis;
    }

    public long logRetentionBytes() {
        return this.logRetentionBytes;
    }

    public long logCleanupIntervalMs() {
        return this.logCleanupIntervalMs;
    }

    public String logCleanupPolicy() {
        return this.logCleanupPolicy;
    }

    public int logCleanerThreads() {
        return this.logCleanerThreads;
    }

    public double logCleanerIoMaxBytesPerSecond() {
        return this.logCleanerIoMaxBytesPerSecond;
    }

    public long logCleanerDedupeBufferSize() {
        return this.logCleanerDedupeBufferSize;
    }

    public int logCleanerIoBufferSize() {
        return this.logCleanerIoBufferSize;
    }

    public double logCleanerDedupeBufferLoadFactor() {
        return this.logCleanerDedupeBufferLoadFactor;
    }

    public long logCleanerBackoffMs() {
        return this.logCleanerBackoffMs;
    }

    public double logCleanerMinCleanRatio() {
        return this.logCleanerMinCleanRatio;
    }

    public boolean logCleanerEnable() {
        return this.logCleanerEnable;
    }

    public long logCleanerDeleteRetentionMs() {
        return this.logCleanerDeleteRetentionMs;
    }

    public int logIndexSizeMaxBytes() {
        return this.logIndexSizeMaxBytes;
    }

    public int logIndexIntervalBytes() {
        return this.logIndexIntervalBytes;
    }

    public long logFlushIntervalMessages() {
        return this.logFlushIntervalMessages;
    }

    public long logDeleteDelayMs() {
        return this.logDeleteDelayMs;
    }

    public long logFlushSchedulerIntervalMs() {
        return this.logFlushSchedulerIntervalMs;
    }

    public long logFlushIntervalMs() {
        return this.logFlushIntervalMs;
    }

    public int logFlushOffsetCheckpointIntervalMs() {
        return this.logFlushOffsetCheckpointIntervalMs;
    }

    public boolean autoCreateTopicsEnable() {
        return this.autoCreateTopicsEnable;
    }

    public int controllerSocketTimeoutMs() {
        return this.controllerSocketTimeoutMs;
    }

    public int controllerMessageQueueSize() {
        return this.controllerMessageQueueSize;
    }

    public int defaultReplicationFactor() {
        return this.defaultReplicationFactor;
    }

    public long replicaLagTimeMaxMs() {
        return this.replicaLagTimeMaxMs;
    }

    public long replicaLagMaxMessages() {
        return this.replicaLagMaxMessages;
    }

    public int replicaSocketTimeoutMs() {
        return this.replicaSocketTimeoutMs;
    }

    public int replicaSocketReceiveBufferBytes() {
        return this.replicaSocketReceiveBufferBytes;
    }

    public int replicaFetchMaxBytes() {
        return this.replicaFetchMaxBytes;
    }

    public int replicaFetchWaitMaxMs() {
        return this.replicaFetchWaitMaxMs;
    }

    public int replicaFetchMinBytes() {
        return this.replicaFetchMinBytes;
    }

    public int numReplicaFetchers() {
        return this.numReplicaFetchers;
    }

    public long replicaHighWatermarkCheckpointIntervalMs() {
        return this.replicaHighWatermarkCheckpointIntervalMs;
    }

    public int fetchPurgatoryPurgeIntervalRequests() {
        return this.fetchPurgatoryPurgeIntervalRequests;
    }

    public int producerPurgatoryPurgeIntervalRequests() {
        return this.producerPurgatoryPurgeIntervalRequests;
    }

    public boolean autoLeaderRebalanceEnable() {
        return this.autoLeaderRebalanceEnable;
    }

    public int leaderImbalancePerBrokerPercentage() {
        return this.leaderImbalancePerBrokerPercentage;
    }

    public int leaderImbalanceCheckIntervalSeconds() {
        return this.leaderImbalanceCheckIntervalSeconds;
    }

    public int controlledShutdownMaxRetries() {
        return this.controlledShutdownMaxRetries;
    }

    public int controlledShutdownRetryBackoffMs() {
        return this.controlledShutdownRetryBackoffMs;
    }

    public boolean controlledShutdownEnable() {
        return this.controlledShutdownEnable;
    }

    public int offsetMetadataMaxSize() {
        return this.offsetMetadataMaxSize;
    }

    public boolean deleteTopicEnable() {
        return this.deleteTopicEnable;
    }

    private KafkaConfig(VerifiableProperties props) {
        this.props = props;
        super(props);
        this.brokerId = props.getIntInRange("broker.id", new Tuple2$mcII$sp(0, Integer.MAX_VALUE));
        this.messageMaxBytes = props.getIntInRange("message.max.bytes", 1000000 + MessageSet$.MODULE$.LogOverhead(), new Tuple2$mcII$sp(0, Integer.MAX_VALUE));
        this.numNetworkThreads = props.getIntInRange("num.network.threads", 3, new Tuple2$mcII$sp(1, Integer.MAX_VALUE));
        this.numIoThreads = props.getIntInRange("num.io.threads", 8, new Tuple2$mcII$sp(1, Integer.MAX_VALUE));
        this.backgroundThreads = props.getIntInRange("background.threads", 4, new Tuple2$mcII$sp(1, Integer.MAX_VALUE));
        this.queuedMaxRequests = props.getIntInRange("queued.max.requests", 500, new Tuple2$mcII$sp(1, Integer.MAX_VALUE));
        this.port = props.getInt("port", 6667);
        this.hostName = props.getString("host.name", null);
        this.advertisedHostName = props.getString("advertised.host.name", this.hostName());
        this.advertisedPort = props.getInt("advertised.port", this.port());
        this.socketSendBufferBytes = props.getInt("socket.send.buffer.bytes", 102400);
        this.socketReceiveBufferBytes = props.getInt("socket.receive.buffer.bytes", 102400);
        this.socketRequestMaxBytes = props.getIntInRange("socket.request.max.bytes", 0x6400000, new Tuple2$mcII$sp(1, Integer.MAX_VALUE));
        this.numPartitions = props.getIntInRange("num.partitions", 1, new Tuple2$mcII$sp(1, Integer.MAX_VALUE));
        this.logDirs = Utils$.MODULE$.parseCsvList(props.getString("log.dirs", props.getString("log.dir", "/tmp/kafka-logs")));
        Predef$.MODULE$.require(this.logDirs().size() > 0);
        this.logSegmentBytes = props.getIntInRange("log.segment.bytes", 0x40000000, new Tuple2$mcII$sp(Message$.MODULE$.MinHeaderSize(), Integer.MAX_VALUE));
        this.logRollHours = props.getIntInRange("log.roll.hours", 168, new Tuple2$mcII$sp(1, Integer.MAX_VALUE));
        this.logRetentionTimeMillis = this.getLogRetentionTimeMillis();
        this.logRetentionBytes = props.getLong("log.retention.bytes", -1L);
        this.logCleanupIntervalMs = props.getLongInRange("log.retention.check.interval.ms", 300000L, new Tuple2$mcLL$sp(1L, Long.MAX_VALUE));
        this.logCleanupPolicy = props.getString("log.cleanup.policy", "delete");
        this.logCleanerThreads = props.getIntInRange("log.cleaner.threads", 1, new Tuple2$mcII$sp(0, Integer.MAX_VALUE));
        this.logCleanerIoMaxBytesPerSecond = props.getDouble("log.cleaner.io.max.bytes.per.second", Double.MAX_VALUE);
        this.logCleanerDedupeBufferSize = props.getLongInRange("log.cleaner.dedupe.buffer.size", 524288000L, new Tuple2$mcLL$sp(0L, Long.MAX_VALUE));
        Predef$.MODULE$.require(this.logCleanerDedupeBufferSize() / (long)this.logCleanerThreads() > 0x100000L, new $anonfun$1(this));
        this.logCleanerIoBufferSize = props.getIntInRange("log.cleaner.io.buffer.size", 524288, new Tuple2$mcII$sp(0, Integer.MAX_VALUE));
        this.logCleanerDedupeBufferLoadFactor = props.getDouble("log.cleaner.io.buffer.load.factor", 0.9);
        this.logCleanerBackoffMs = props.getLongInRange("log.cleaner.backoff.ms", 15000L, new Tuple2$mcLL$sp(0L, Long.MAX_VALUE));
        this.logCleanerMinCleanRatio = props.getDouble("log.cleaner.min.cleanable.ratio", 0.5);
        this.logCleanerEnable = props.getBoolean("log.cleaner.enable", false);
        this.logCleanerDeleteRetentionMs = props.getLong("log.cleaner.delete.retention.ms", 86400000L);
        this.logIndexSizeMaxBytes = props.getIntInRange("log.index.size.max.bytes", 0xA00000, new Tuple2$mcII$sp(4, Integer.MAX_VALUE));
        this.logIndexIntervalBytes = props.getIntInRange("log.index.interval.bytes", 4096, new Tuple2$mcII$sp(0, Integer.MAX_VALUE));
        this.logFlushIntervalMessages = props.getLongInRange("log.flush.interval.messages", Long.MAX_VALUE, new Tuple2$mcLL$sp(1L, Long.MAX_VALUE));
        this.logDeleteDelayMs = props.getLongInRange("log.segment.delete.delay.ms", 60000L, new Tuple2$mcLL$sp(0L, Long.MAX_VALUE));
        this.logFlushSchedulerIntervalMs = props.getLong("log.flush.scheduler.interval.ms", Long.MAX_VALUE);
        this.logFlushIntervalMs = props.getLong("log.flush.interval.ms", this.logFlushSchedulerIntervalMs());
        this.logFlushOffsetCheckpointIntervalMs = props.getIntInRange("log.flush.offset.checkpoint.interval.ms", 60000, new Tuple2$mcII$sp(0, Integer.MAX_VALUE));
        this.autoCreateTopicsEnable = props.getBoolean("auto.create.topics.enable", true);
        this.controllerSocketTimeoutMs = props.getInt("controller.socket.timeout.ms", 30000);
        this.controllerMessageQueueSize = props.getInt("controller.message.queue.size", 10);
        this.defaultReplicationFactor = props.getInt("default.replication.factor", 1);
        this.replicaLagTimeMaxMs = props.getLong("replica.lag.time.max.ms", 10000L);
        this.replicaLagMaxMessages = props.getLong("replica.lag.max.messages", 4000L);
        this.replicaSocketTimeoutMs = props.getInt("replica.socket.timeout.ms", ConsumerConfig$.MODULE$.SocketTimeout());
        this.replicaSocketReceiveBufferBytes = props.getInt("replica.socket.receive.buffer.bytes", ConsumerConfig$.MODULE$.SocketBufferSize());
        this.replicaFetchMaxBytes = props.getIntInRange("replica.fetch.max.bytes", ConsumerConfig$.MODULE$.FetchSize(), new Tuple2$mcII$sp(this.messageMaxBytes(), Integer.MAX_VALUE));
        this.replicaFetchWaitMaxMs = props.getInt("replica.fetch.wait.max.ms", 500);
        Predef$.MODULE$.require((long)this.replicaFetchWaitMaxMs() <= this.replicaLagTimeMaxMs(), new $anonfun$2(this));
        this.replicaFetchMinBytes = props.getInt("replica.fetch.min.bytes", 1);
        this.numReplicaFetchers = props.getInt("num.replica.fetchers", 1);
        this.replicaHighWatermarkCheckpointIntervalMs = props.getLong("replica.high.watermark.checkpoint.interval.ms", 5000L);
        this.fetchPurgatoryPurgeIntervalRequests = props.getInt("fetch.purgatory.purge.interval.requests", 10000);
        this.producerPurgatoryPurgeIntervalRequests = props.getInt("producer.purgatory.purge.interval.requests", 10000);
        this.autoLeaderRebalanceEnable = props.getBoolean("auto.leader.rebalance.enable", false);
        this.leaderImbalancePerBrokerPercentage = props.getInt("leader.imbalance.per.broker.percentage", 10);
        this.leaderImbalanceCheckIntervalSeconds = props.getInt("leader.imbalance.check.interval.seconds", 300);
        this.controlledShutdownMaxRetries = props.getInt("controlled.shutdown.max.retries", 3);
        this.controlledShutdownRetryBackoffMs = props.getInt("controlled.shutdown.retry.backoff.ms", 5000);
        this.controlledShutdownEnable = props.getBoolean("controlled.shutdown.enable", false);
        this.offsetMetadataMaxSize = props.getInt("offset.metadata.max.bytes", 1024);
        this.deleteTopicEnable = props.getBoolean("delete.topic.enable", false);
    }
}

