/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.LeaderAndIsr;
import kafka.common.LeaderElectionNotNeededException;
import kafka.common.NoReplicaOnlineException;
import kafka.common.StateChangeFailedException;
import kafka.common.TopicAndPartition;
import kafka.controller.Callbacks;
import kafka.controller.ControllerBrokerRequestBatch;
import kafka.controller.ControllerContext;
import kafka.controller.KafkaController;
import kafka.controller.KafkaController$;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.NewPartition$;
import kafka.controller.NoOpLeaderSelector;
import kafka.controller.NonExistentPartition$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OnlinePartition$;
import kafka.controller.PartitionLeaderSelector;
import kafka.controller.PartitionState;
import kafka.controller.PartitionStateMachine$;
import kafka.controller.PartitionStateMachine$$anonfun$kafka$controller$PartitionStateMachine$;
import kafka.controller.PartitionStateMachine$AddPartitionsListener$;
import kafka.controller.PartitionStateMachine$DeleteTopicsListener$;
import kafka.controller.PartitionStateMachine$TopicChangeListener$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Utils$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.IZkChildListener;
import org.I0Itec.zkclient.IZkDataListener;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.ScalaObject;
import scala.Some;
import scala.Tuple2;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t\u0015h\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\u0004\u0003+A\u000b'\u000f^5uS>t7\u000b^1uK6\u000b7\r[5oK*\u00111\u0001B\u0001\u000bG>tGO]8mY\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M!\u0001\u0001\u0003\t\u0017!\tIa\"D\u0001\u000b\u0015\tYA\"\u0001\u0003mC:<'\"A\u0007\u0002\t)\fg/Y\u0005\u0003\u001f)\u0011aa\u00142kK\u000e$\bCA\t\u0015\u001b\u0005\u0011\"BA\n\u0005\u0003\u0015)H/\u001b7t\u0013\t)\"CA\u0004M_\u001e<\u0017N\\4\u0011\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0003\u0017M\u001b\u0017\r\\1PE*,7\r\u001e\u0005\t\u0007\u0001\u0011\t\u0011)A\u0005;A\u0011adH\u0007\u0002\u0005%\u0011\u0001E\u0001\u0002\u0010\u0017\u000647.Y\"p]R\u0014x\u000e\u001c7fe\")!\u0005\u0001C\u0001G\u00051A(\u001b8jiz\"\"\u0001J\u0013\u0011\u0005y\u0001\u0001\"B\u0002\"\u0001\u0004i\u0002bB\u0014\u0001\u0005\u0004%I\u0001K\u0001\u0012G>tGO]8mY\u0016\u00148i\u001c8uKb$X#A\u0015\u0011\u0005yQ\u0013BA\u0016\u0003\u0005E\u0019uN\u001c;s_2dWM]\"p]R,\u0007\u0010\u001e\u0005\u0007[\u0001\u0001\u000b\u0011B\u0015\u0002%\r|g\u000e\u001e:pY2,'oQ8oi\u0016DH\u000f\t\u0005\b_\u0001\u0011\r\u0011\"\u00031\u00031\u0019wN\u001c;s_2dWM]%e+\u0005\t\u0004CA\f3\u0013\t\u0019\u0004DA\u0002J]RDa!\u000e\u0001!\u0002\u0013\t\u0014!D2p]R\u0014x\u000e\u001c7fe&#\u0007\u0005C\u00048\u0001\t\u0007I\u0011\u0002\u001d\u0002\u0011i\\7\t\\5f]R,\u0012!\u000f\t\u0003u\u0005k\u0011a\u000f\u0006\u0003yu\n\u0001B_6dY&,g\u000e\u001e\u0006\u0003}}\na!\u0013\u0019Ji\u0016\u001c'\"\u0001!\u0002\u0007=\u0014x-\u0003\u0002Cw\tA!l[\"mS\u0016tG\u000f\u0003\u0004E\u0001\u0001\u0006I!O\u0001\nu.\u001cE.[3oi\u0002BqA\u0012\u0001A\u0002\u0013\u0005q)\u0001\bqCJ$\u0018\u000e^5p]N#\u0018\r^3\u0016\u0003!\u0003B!\u0013(Q-6\t!J\u0003\u0002L\u0019\u00069Q.\u001e;bE2,'BA'\u0019\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\u001f*\u00131!T1q!\t\tF+D\u0001S\u0015\t\u0019F!\u0001\u0004d_6lwN\\\u0005\u0003+J\u0013\u0011\u0003V8qS\u000e\fe\u000e\u001a)beRLG/[8o!\tqr+\u0003\u0002Y\u0005\tq\u0001+\u0019:uSRLwN\\*uCR,\u0007b\u0002.\u0001\u0001\u0004%\taW\u0001\u0013a\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f?\u0012*\u0017\u000f\u0006\u0002]?B\u0011q#X\u0005\u0003=b\u0011A!\u00168ji\"9\u0001-WA\u0001\u0002\u0004A\u0015a\u0001=%c!1!\r\u0001Q!\n!\u000bq\u0002]1si&$\u0018n\u001c8Ti\u0006$X\r\t\u0005\bI\u0002\u0011\r\u0011\"\u0001f\u0003I\u0011'o\\6feJ+\u0017/^3ti\n\u000bGo\u00195\u0016\u0003\u0019\u0004\"AH4\n\u0005!\u0014!\u0001H\"p]R\u0014x\u000e\u001c7fe\n\u0013xn[3s%\u0016\fX/Z:u\u0005\u0006$8\r\u001b\u0005\u0007U\u0002\u0001\u000b\u0011\u00024\u0002'\t\u0014xn[3s%\u0016\fX/Z:u\u0005\u0006$8\r\u001b\u0011\t\u000f1\u0004!\u0019!C\u0005[\u0006Q\u0001.Y:Ti\u0006\u0014H/\u001a3\u0016\u00039\u0004\"a\u001c<\u000e\u0003AT!!\u001d:\u0002\r\u0005$x.\\5d\u0015\t\u0019H/\u0001\u0006d_:\u001cWO\u001d:f]RT!!\u001e\u0007\u0002\tU$\u0018\u000e\\\u0005\u0003oB\u0014Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0007BB=\u0001A\u0003%a.A\u0006iCN\u001cF/\u0019:uK\u0012\u0004\u0003bB>\u0001\u0005\u0004%I\u0001`\u0001\u001c]>|\u0005\u000fU1si&$\u0018n\u001c8MK\u0006$WM]*fY\u0016\u001cGo\u001c:\u0016\u0003u\u0004\"A\b@\n\u0005}\u0014!A\u0005(p\u001fBdU-\u00193feN+G.Z2u_JDq!a\u0001\u0001A\u0003%Q0\u0001\u000fo_>\u0003\b+\u0019:uSRLwN\u001c'fC\u0012,'oU3mK\u000e$xN\u001d\u0011\t\u0013\u0005\u001d\u0001A1A\u0005\n\u0005%\u0011!E:uCR,7\t[1oO\u0016dunZ4feV\u0011\u00111\u0002\t\u0005\u0003\u001b\t\u0019BD\u0002\u001f\u0003\u001fI1!!\u0005\u0003\u0003=Y\u0015MZ6b\u0007>tGO]8mY\u0016\u0014\u0018\u0002BA\u000b\u0003/\u0011\u0011c\u0015;bi\u0016\u001c\u0005.\u00198hK2{wmZ3s\u0015\r\t\tB\u0001\u0005\t\u00037\u0001\u0001\u0015!\u0003\u0002\f\u0005\u00112\u000f^1uK\u000eC\u0017M\\4f\u0019><w-\u001a:!\u0011%\ty\u0002\u0001a\u0001\n\u0013\t\t#A\nu_BL7m\u00115b]\u001e,G*[:uK:,'/\u0006\u0002\u0002$A!\u0011QEA\u0014\u001b\u0005\u0001aACA\u0015\u0001\u0011\u0005\t\u0011!\u0001\u0002,\t\u0019Bk\u001c9jG\u000eC\u0017M\\4f\u0019&\u001cH/\u001a8feN9\u0011q\u0005\u0005\u0002.A1\u0002c\u0001\u001e\u00020%\u0019\u0011\u0011G\u001e\u0003!%S6n\u00115jY\u0012d\u0015n\u001d;f]\u0016\u0014\bb\u0002\u0012\u0002(\u0011\u0005\u0011Q\u0007\u000b\u0003\u0003GA\u0001\"!\u000f\u0002(\u0011\u0005\u00111H\u0001\u0012Q\u0006tG\r\\3DQ&dGm\u00115b]\u001e,G#\u0002/\u0002>\u0005=\u0003\u0002CA \u0003o\u0001\r!!\u0011\u0002\u0015A\f'/\u001a8u!\u0006$\b\u000e\u0005\u0003\u0002D\u0005%cbA\f\u0002F%\u0019\u0011q\t\r\u0002\rA\u0013X\rZ3g\u0013\u0011\tY%!\u0014\u0003\rM#(/\u001b8h\u0015\r\t9\u0005\u0007\u0005\t\u0003#\n9\u00041\u0001\u0002T\u0005A1\r[5mIJ,g\u000e\u0005\u0004\u0002V\u0005]\u0013\u0011I\u0007\u0002i&\u0019\u0011\u0011\f;\u0003\t1K7\u000f\u001e\u0015\u0007\u0003o\ti&a\u0019\u0011\u0007]\ty&C\u0002\u0002ba\u0011a\u0001\u001e5s_^\u001c8EAA3!\u0011\t9'a\u001e\u000f\t\u0005%\u00141\u000f\b\u0005\u0003W\n\t(\u0004\u0002\u0002n)\u0019\u0011q\u000e\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0012bAA;1\u00059\u0001/Y2lC\u001e,\u0017\u0002BA=\u0003w\u0012\u0011\"\u0012=dKB$\u0018n\u001c8\u000b\u0007\u0005U\u0004\u0004C\u0005\u0002\u0000\u0001\u0001\r\u0011\"\u0003\u0002\u0002\u00069Bo\u001c9jG\u000eC\u0017M\\4f\u0019&\u001cH/\u001a8fe~#S-\u001d\u000b\u00049\u0006\r\u0005\"\u00031\u0002~\u0005\u0005\t\u0019AA\u0012\u0011!\t9\t\u0001Q!\n\u0005\r\u0012\u0001\u0006;pa&\u001c7\t[1oO\u0016d\u0015n\u001d;f]\u0016\u0014\b\u0005C\u0005\u0002\f\u0002\u0001\r\u0011\"\u0003\u0002\u000e\u0006!B-\u001a7fi\u0016$v\u000e]5dg2K7\u000f^3oKJ,\"!a$\u0011\t\u0005\u0015\u0012\u0011\u0013\u0004\u000b\u0003'\u0003A\u0011!A\u0001\u0002\u0005U%\u0001\u0006#fY\u0016$X\rV8qS\u000e\u001cH*[:uK:,'oE\u0004\u0002\u0012\"\ti\u0003\u0005\f\t\u000f\t\n\t\n\"\u0001\u0002\u001aR\u0011\u0011q\u0012\u0005\to\u0005E%\u0019!C\u0001q!9A)!%!\u0002\u0013I\u0004\u0002CA\u001d\u0003##\t!!)\u0015\u000bq\u000b\u0019+!*\t\u0011\u0005}\u0012q\u0014a\u0001\u0003\u0003B\u0001\"!\u0015\u0002 \u0002\u0007\u00111\u000b\u0015\u0007\u0003?\u000bi&a\u0019\t\u0011\u0005-\u0016\u0011\u0013C\u0001\u0003[\u000b\u0011\u0003[1oI2,G)\u0019;b\t\u0016dW\r^3e)\ra\u0016q\u0016\u0005\t\u0003c\u000bI\u000b1\u0001\u0002B\u0005AA-\u0019;b!\u0006$\b\u000e\u000b\u0004\u0002*\u0006u\u00131\r\u0005\n\u0003o\u0003\u0001\u0019!C\u0005\u0003s\u000b\u0001\u0004Z3mKR,Gk\u001c9jGNd\u0015n\u001d;f]\u0016\u0014x\fJ3r)\ra\u00161\u0018\u0005\nA\u0006U\u0016\u0011!a\u0001\u0003\u001fC\u0001\"a0\u0001A\u0003&\u0011qR\u0001\u0016I\u0016dW\r^3U_BL7m\u001d'jgR,g.\u001a:!\u0011%\t\u0019\r\u0001a\u0001\n\u0013\t)-A\u000bbI\u0012\u0004\u0016M\u001d;ji&|gn\u001d'jgR,g.\u001a:\u0016\u0005\u0005\u001d\u0007CB%O\u0003\u0003\nI\r\u0005\u0003\u0002&\u0005-gACAg\u0001\u0011\u0005\t\u0011!\u0001\u0002P\n)\u0012\t\u001a3QCJ$\u0018\u000e^5p]Nd\u0015n\u001d;f]\u0016\u00148cBAf\u0011\u0005E\u0007C\u0006\t\u0004u\u0005M\u0017bAAkw\ty\u0011JW6ECR\fG*[:uK:,'\u000fC\u0006\u0002Z\u0006-'\u0011!Q\u0001\n\u0005\u0005\u0013!\u0002;pa&\u001c\u0007b\u0002\u0012\u0002L\u0012\u0005\u0011Q\u001c\u000b\u0005\u0003\u0013\fy\u000e\u0003\u0005\u0002Z\u0006m\u0007\u0019AA!\u0011!\t\u0019/a3\u0005\u0002\u0005\u0015\u0018\u0001\u00055b]\u0012dW\rR1uC\u000eC\u0017M\\4f)\u0015a\u0016q]Au\u0011!\t\t,!9A\u0002\u0005\u0005\u0003bBAv\u0003C\u0004\r\u0001C\u0001\u0005I\u0006$\u0018\r\u000b\u0004\u0002b\u0006u\u00131\r\u0005\t\u0003W\u000bY\r\"\u0001\u0002rR\u0019A,a=\t\u0011\u0005}\u0012q\u001ea\u0001\u0003\u0003Bc!a<\u0002^\u0005\r\u0004\"CA}\u0001\u0001\u0007I\u0011BA~\u0003e\tG\r\u001a)beRLG/[8og2K7\u000f^3oKJ|F%Z9\u0015\u0007q\u000bi\u0010C\u0005a\u0003o\f\t\u00111\u0001\u0002H\"A!\u0011\u0001\u0001!B\u0013\t9-\u0001\fbI\u0012\u0004\u0016M\u001d;ji&|gn\u001d'jgR,g.\u001a:!\u0011\u001d\u0011)\u0001\u0001C\u0001\u0005\u000f\tqa\u001d;beR,\b\u000fF\u0001]\u0011\u001d\u0011Y\u0001\u0001C\u0001\u0005\u000f\t\u0011C]3hSN$XM\u001d'jgR,g.\u001a:t\u0011\u001d\u0011y\u0001\u0001C\u0001\u0005\u000f\t\u0001b\u001d5vi\u0012|wO\u001c\u0005\b\u0005'\u0001A\u0011\u0001B\u0004\u0003\u0005\"(/[4hKJ|e\u000e\\5oKB\u000b'\u000f^5uS>t7\u000b^1uK\u000eC\u0017M\\4f\u0011\u001d\u00119\u0002\u0001C\u0001\u00053\t\u0011\u0003]1si&$\u0018n\u001c8t\u0013:\u001cF/\u0019;f)\u0011\u0011YBa\t\u0011\u000b\tu!q\u0004)\u000e\u00031K1A!\tM\u0005\r\u0019V\r\u001e\u0005\b\u0005K\u0011)\u00021\u0001W\u0003\u0015\u0019H/\u0019;f\u0011\u001d\u0011I\u0003\u0001C\u0001\u0005W\t!\u0003[1oI2,7\u000b^1uK\u000eC\u0017M\\4fgRIAL!\f\u00032\tU\"q\b\u0005\t\u0005_\u00119\u00031\u0001\u0003\u001c\u0005Q\u0001/\u0019:uSRLwN\\:\t\u000f\tM\"q\u0005a\u0001-\u0006YA/\u0019:hKR\u001cF/\u0019;f\u0011)\u00119Da\n\u0011\u0002\u0003\u0007!\u0011H\u0001\u000fY\u0016\fG-\u001a:TK2,7\r^8s!\rq\"1H\u0005\u0004\u0005{\u0011!a\u0006)beRLG/[8o\u0019\u0016\fG-\u001a:TK2,7\r^8s\u0011)\u0011\tEa\n\u0011\u0002\u0003\u0007!1I\u0001\nG\u0006dGNY1dWN\u00042A\bB#\u0013\r\u00119E\u0001\u0002\n\u0007\u0006dGNY1dWNDqAa\u0013\u0001\t\u0013\u0011i%A\tiC:$G.Z*uCR,7\t[1oO\u0016$2\u0002\u0018B(\u0005#\u0012)Fa\u0016\u0003Z!A\u0011\u0011\u001cB%\u0001\u0004\t\t\u0005C\u0004\u0003T\t%\u0003\u0019A\u0019\u0002\u0013A\f'\u000f^5uS>t\u0007b\u0002B\u001a\u0005\u0013\u0002\rA\u0016\u0005\t\u0005o\u0011I\u00051\u0001\u0003:!A!\u0011\tB%\u0001\u0004\u0011\u0019\u0005C\u0004\u0003^\u0001!IAa\u0002\u00021%t\u0017\u000e^5bY&TX\rU1si&$\u0018n\u001c8Ti\u0006$X\rC\u0004\u0003b\u0001!IAa\u0019\u00023\u0005\u001c8/\u001a:u-\u0006d\u0017\u000e\u001a)sKZLw.^:Ti\u0006$Xm\u001d\u000b\b9\n\u0015$\u0011\u000eB:\u0011\u001d\u00119Ga\u0018A\u0002A\u000b\u0011\u0003^8qS\u000e\fe\u000e\u001a)beRLG/[8o\u0011!\u0011YGa\u0018A\u0002\t5\u0014A\u00034s_6\u001cF/\u0019;fgB)!Q\u0004B8-&\u0019!\u0011\u000f'\u0003\u0007M+\u0017\u000fC\u0004\u00034\t}\u0003\u0019\u0001,\t\u000f\t]\u0004\u0001\"\u0003\u0003z\u0005Q\u0012m]:jO:\u0014V\r\u001d7jG\u0006\u001cHk\u001c)beRLG/[8ogR)ALa\u001f\u0003~!A\u0011\u0011\u001cB;\u0001\u0004\t\t\u0005C\u0004\u0003T\tU\u0004\u0019A\u0019\t\u000f\t\u0005\u0005\u0001\"\u0003\u0003\u0004\u0006\u0011\u0013N\\5uS\u0006d\u0017N_3MK\u0006$WM]!oI&\u001b(OR8s!\u0006\u0014H/\u001b;j_:$2\u0001\u0018BC\u0011\u001d\u00119Ga A\u0002ACqA!#\u0001\t\u0003\u0011Y)A\ffY\u0016\u001cG\u000fT3bI\u0016\u0014hi\u001c:QCJ$\u0018\u000e^5p]R9AL!$\u0003\u0010\nE\u0005\u0002CAm\u0005\u000f\u0003\r!!\u0011\t\u000f\tM#q\u0011a\u0001c!A!q\u0007BD\u0001\u0004\u0011I\u0004C\u0004\u0003\u0016\u0002!IAa&\u00027I,w-[:uKJ$v\u000e]5d\u0007\"\fgnZ3MSN$XM\\3s)\t\u0011I\n\u0005\u0004\u0002V\u0005]#1\u0014\t\u0004\u0013\tu\u0015bAA&\u0015!9!\u0011\u0015\u0001\u0005\u0002\t\r\u0016a\b:fO&\u001cH/\u001a:QCJ$\u0018\u000e^5p]\u000eC\u0017M\\4f\u0019&\u001cH/\u001a8feR\u0019AL!*\t\u0011\u0005e'q\u0014a\u0001\u0003\u0003BqA!+\u0001\t\u0003\u0011Y+A\u0011eKJ,w-[:uKJ\u0004\u0016M\u001d;ji&|gn\u00115b]\u001e,G*[:uK:,'\u000fF\u0002]\u0005[C\u0001\"!7\u0003(\u0002\u0007\u0011\u0011\t\u0005\b\u0005c\u0003A\u0011\u0002BL\u0003m\u0011XmZ5ti\u0016\u0014H)\u001a7fi\u0016$v\u000e]5d\u0019&\u001cH/\u001a8fe\"9!Q\u0017\u0001\u0005\n\t]\u0016\u0001J4fi2+\u0017\rZ3s\u0013N\u0014\u0018I\u001c3Fa>\u001c\u0007n\u0014:UQJ|w/\u0012=dKB$\u0018n\u001c8\u0015\r\te&q\u0018Ba!\rq\"1X\u0005\u0004\u0005{\u0013!a\u0007'fC\u0012,'/S:s\u0003:$7i\u001c8ue>dG.\u001a:Fa>\u001c\u0007\u000e\u0003\u0005\u0002Z\nM\u0006\u0019AA!\u0011\u001d\u0011\u0019Fa-A\u0002EB\u0011B!2\u0001#\u0003%\tAa2\u00029!\fg\u000e\u001a7f'R\fG/Z\"iC:<Wm\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!\u0011\u001a\u0016\u0005\u0005s\u0011Ym\u000b\u0002\u0003NB!!q\u001aBm\u001b\t\u0011\tN\u0003\u0003\u0003T\nU\u0017!C;oG\",7m[3e\u0015\r\u00119\u000eG\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002Bn\u0005#\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\u0011y\u000eAI\u0001\n\u0003\u0011\t/\u0001\u000fiC:$G.Z*uCR,7\t[1oO\u0016\u001cH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\t\r(\u0006\u0002B\"\u0005\u0017\u0004")
public class PartitionStateMachine
implements Logging,
ScalaObject {
    public final KafkaController kafka$controller$PartitionStateMachine$$controller;
    private final ControllerContext kafka$controller$PartitionStateMachine$$controllerContext;
    private final int kafka$controller$PartitionStateMachine$$controllerId;
    private final ZkClient kafka$controller$PartitionStateMachine$$zkClient;
    private Map<TopicAndPartition, PartitionState> partitionState;
    private final ControllerBrokerRequestBatch brokerRequestBatch;
    private final AtomicBoolean kafka$controller$PartitionStateMachine$$hasStarted;
    private final NoOpLeaderSelector noOpPartitionLeaderSelector;
    private final KafkaController.StateChangeLogger stateChangeLogger;
    private TopicChangeListener topicChangeListener;
    private DeleteTopicsListener deleteTopicsListener;
    private Map<String, AddPartitionsListener> addPartitionsListener;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        PartitionStateMachine partitionStateMachine = this;
        synchronized (partitionStateMachine) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string2) {
        this.logIdent = string2;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
        this.loggerName = string2;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    public void trace(Function0 msg) {
        Logging$class.trace(this, msg);
    }

    public Object trace(Function0 e) {
        return Logging$class.trace(this, e);
    }

    public void trace(Function0 msg, Function0 e) {
        Logging$class.trace(this, msg, e);
    }

    public void swallowTrace(Function0 action) {
        Logging$class.swallowTrace(this, action);
    }

    public void debug(Function0 msg) {
        Logging$class.debug(this, msg);
    }

    public Object debug(Function0 e) {
        return Logging$class.debug(this, e);
    }

    public void debug(Function0 msg, Function0 e) {
        Logging$class.debug(this, msg, e);
    }

    public void swallowDebug(Function0 action) {
        Logging$class.swallowDebug(this, action);
    }

    public void info(Function0 msg) {
        Logging$class.info(this, msg);
    }

    public Object info(Function0 e) {
        return Logging$class.info(this, e);
    }

    public void info(Function0 msg, Function0 e) {
        Logging$class.info(this, msg, e);
    }

    public void swallowInfo(Function0 action) {
        Logging$class.swallowInfo(this, action);
    }

    public void warn(Function0 msg) {
        Logging$class.warn(this, msg);
    }

    public Object warn(Function0 e) {
        return Logging$class.warn(this, e);
    }

    public void warn(Function0 msg, Function0 e) {
        Logging$class.warn(this, msg, e);
    }

    public void swallowWarn(Function0 action) {
        Logging$class.swallowWarn(this, action);
    }

    public void swallow(Function0 action) {
        Logging$class.swallow(this, action);
    }

    public void error(Function0 msg) {
        Logging$class.error(this, msg);
    }

    public Object error(Function0 e) {
        return Logging$class.error(this, e);
    }

    public void error(Function0 msg, Function0 e) {
        Logging$class.error(this, msg, e);
    }

    public void swallowError(Function0 action) {
        Logging$class.swallowError(this, action);
    }

    public void fatal(Function0 msg) {
        Logging$class.fatal(this, msg);
    }

    public Object fatal(Function0 e) {
        return Logging$class.fatal(this, e);
    }

    public void fatal(Function0 msg, Function0 e) {
        Logging$class.fatal(this, msg, e);
    }

    public /* synthetic */ Callbacks handleStateChanges$default$4() {
        return new Callbacks.CallbackBuilder().build();
    }

    public /* synthetic */ PartitionLeaderSelector handleStateChanges$default$3() {
        return this.noOpPartitionLeaderSelector();
    }

    public final ControllerContext kafka$controller$PartitionStateMachine$$controllerContext() {
        return this.kafka$controller$PartitionStateMachine$$controllerContext;
    }

    public final int kafka$controller$PartitionStateMachine$$controllerId() {
        return this.kafka$controller$PartitionStateMachine$$controllerId;
    }

    public final ZkClient kafka$controller$PartitionStateMachine$$zkClient() {
        return this.kafka$controller$PartitionStateMachine$$zkClient;
    }

    public Map<TopicAndPartition, PartitionState> partitionState() {
        return this.partitionState;
    }

    public void partitionState_$eq(Map<TopicAndPartition, PartitionState> map2) {
        this.partitionState = map2;
    }

    public ControllerBrokerRequestBatch brokerRequestBatch() {
        return this.brokerRequestBatch;
    }

    public final AtomicBoolean kafka$controller$PartitionStateMachine$$hasStarted() {
        return this.kafka$controller$PartitionStateMachine$$hasStarted;
    }

    private NoOpLeaderSelector noOpPartitionLeaderSelector() {
        return this.noOpPartitionLeaderSelector;
    }

    private KafkaController.StateChangeLogger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    private TopicChangeListener topicChangeListener() {
        return this.topicChangeListener;
    }

    private void topicChangeListener_$eq(TopicChangeListener topicChangeListener) {
        this.topicChangeListener = topicChangeListener;
    }

    private DeleteTopicsListener deleteTopicsListener() {
        return this.deleteTopicsListener;
    }

    private void deleteTopicsListener_$eq(DeleteTopicsListener deleteTopicsListener) {
        this.deleteTopicsListener = deleteTopicsListener;
    }

    private Map<String, AddPartitionsListener> addPartitionsListener() {
        return this.addPartitionsListener;
    }

    private void addPartitionsListener_$eq(Map<String, AddPartitionsListener> map2) {
        this.addPartitionsListener = map2;
    }

    public void startup() {
        this.initializePartitionState();
        this.kafka$controller$PartitionStateMachine$$hasStarted().set(true);
        this.triggerOnlinePartitionStateChange();
        this.info((Function0<String>)new $anonfun$startup$1(this));
    }

    public void registerListeners() {
        this.registerTopicChangeListener();
        if (this.kafka$controller$PartitionStateMachine$$controller.config().deleteTopicEnable()) {
            this.registerDeleteTopicListener();
        }
    }

    public void shutdown() {
        this.kafka$controller$PartitionStateMachine$$hasStarted().set(false);
        this.partitionState().clear();
    }

    public void triggerOnlinePartitionStateChange() {
        try {
            this.brokerRequestBatch().newBatch();
            this.partitionState().withFilter(new $anonfun$triggerOnlinePartitionStateChange$1(this)).foreach(new $anonfun$triggerOnlinePartitionStateChange$2(this));
            this.brokerRequestBatch().sendRequestsToBrokers(this.kafka$controller$PartitionStateMachine$$controller.epoch(), this.kafka$controller$PartitionStateMachine$$controllerContext().correlationId().getAndIncrement());
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)new $anonfun$triggerOnlinePartitionStateChange$3(this), (Function0<Throwable>)new $anonfun$triggerOnlinePartitionStateChange$4(this, throwable));
        }
    }

    public Set<TopicAndPartition> partitionsInState(PartitionState state$1) {
        return ((MapLike)this.partitionState().filter(new $anonfun$partitionsInState$1(this, state$1))).keySet();
    }

    public void handleStateChanges(Set<TopicAndPartition> partitions$1, PartitionState targetState$1, PartitionLeaderSelector leaderSelector$1, Callbacks callbacks$1) {
        this.info((Function0<String>)new $anonfun$handleStateChanges$1(this, partitions$1, targetState$1));
        try {
            this.brokerRequestBatch().newBatch();
            partitions$1.foreach(new $anonfun$handleStateChanges$2(this, targetState$1, leaderSelector$1, callbacks$1));
            this.brokerRequestBatch().sendRequestsToBrokers(this.kafka$controller$PartitionStateMachine$$controller.epoch(), this.kafka$controller$PartitionStateMachine$$controllerContext().correlationId().getAndIncrement());
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)new $anonfun$handleStateChanges$3(this, targetState$1), (Function0<Throwable>)new $anonfun$handleStateChanges$4(this, throwable));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void kafka$controller$PartitionStateMachine$$handleStateChange(String topic, int partition2, PartitionState targetState$2, PartitionLeaderSelector leaderSelector, Callbacks callbacks) {
        TopicAndPartition topicAndPartition$1 = new TopicAndPartition(topic, partition2);
        if (!this.kafka$controller$PartitionStateMachine$$hasStarted().get()) throw new StateChangeFailedException(Predef$.MODULE$.augmentString("Controller %d epoch %d initiated state change for partition %s to %s failed because the partition state machine has not started").format((Seq<Object>)Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.kafka$controller$PartitionStateMachine$$controllerId()), BoxesRunTime.boxToInteger(this.kafka$controller$PartitionStateMachine$$controller.epoch()), topicAndPartition$1, targetState$2})));
        PartitionState currState$1 = (PartitionState)this.partitionState().getOrElseUpdate(topicAndPartition$1, new $anonfun$2(this));
        try {
            PartitionState partitionState = targetState$2;
            NewPartition$ newPartition$ = NewPartition$.MODULE$;
            PartitionState partitionState2 = partitionState;
            if (!(newPartition$ != null ? !newPartition$.equals(partitionState2) : partitionState2 != null)) {
                this.assertValidPreviousStates(topicAndPartition$1, (Seq<PartitionState>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new NonExistentPartition$[]{NonExistentPartition$.MODULE$})), NewPartition$.MODULE$);
                this.assignReplicasToPartitions(topic, partition2);
                this.partitionState().put(topicAndPartition$1, NewPartition$.MODULE$);
                String assignedReplicas$1 = ((TraversableOnce)this.kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().apply(topicAndPartition$1)).mkString(",");
                this.stateChangeLogger().trace((Function0<String>)new $anonfun$kafka$controller$PartitionStateMachine$$handleStateChange$1(this, targetState$2, topicAndPartition$1, currState$1, assignedReplicas$1));
                return;
            } else {
                OnlinePartition$ onlinePartition$ = OnlinePartition$.MODULE$;
                PartitionState partitionState3 = partitionState;
                if (!(onlinePartition$ != null ? !onlinePartition$.equals(partitionState3) : partitionState3 != null)) {
                    this.assertValidPreviousStates(topicAndPartition$1, (Seq<PartitionState>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Product[]{NewPartition$.MODULE$, OnlinePartition$.MODULE$, OfflinePartition$.MODULE$})), OnlinePartition$.MODULE$);
                    PartitionState partitionState4 = (PartitionState)this.partitionState().apply(topicAndPartition$1);
                    NewPartition$ newPartition$2 = NewPartition$.MODULE$;
                    PartitionState partitionState5 = partitionState4;
                    if (!(newPartition$2 != null ? !newPartition$2.equals(partitionState5) : partitionState5 != null)) {
                        this.initializeLeaderAndIsrForPartition(topicAndPartition$1);
                    } else {
                        OfflinePartition$ offlinePartition$ = OfflinePartition$.MODULE$;
                        PartitionState partitionState6 = partitionState4;
                        if (!(offlinePartition$ != null ? !offlinePartition$.equals(partitionState6) : partitionState6 != null)) {
                            this.electLeaderForPartition(topic, partition2, leaderSelector);
                        } else {
                            OnlinePartition$ onlinePartition$2 = OnlinePartition$.MODULE$;
                            PartitionState partitionState7 = partitionState4;
                            if (!(onlinePartition$2 != null ? !onlinePartition$2.equals(partitionState7) : partitionState7 != null)) {
                                this.electLeaderForPartition(topic, partition2, leaderSelector);
                            }
                        }
                    }
                    this.partitionState().put(topicAndPartition$1, OnlinePartition$.MODULE$);
                    int leader$1 = ((LeaderIsrAndControllerEpoch)this.kafka$controller$PartitionStateMachine$$controllerContext().partitionLeadershipInfo().apply(topicAndPartition$1)).leaderAndIsr().leader();
                    this.stateChangeLogger().trace((Function0<String>)new $anonfun$kafka$controller$PartitionStateMachine$$handleStateChange$2(this, targetState$2, topicAndPartition$1, currState$1, leader$1));
                    return;
                } else {
                    OfflinePartition$ offlinePartition$ = OfflinePartition$.MODULE$;
                    PartitionState partitionState8 = partitionState;
                    if (!(offlinePartition$ != null ? !offlinePartition$.equals(partitionState8) : partitionState8 != null)) {
                        this.assertValidPreviousStates(topicAndPartition$1, (Seq<PartitionState>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Product[]{NewPartition$.MODULE$, OnlinePartition$.MODULE$, OfflinePartition$.MODULE$})), OfflinePartition$.MODULE$);
                        this.stateChangeLogger().trace((Function0<String>)new $anonfun$kafka$controller$PartitionStateMachine$$handleStateChange$3(this, targetState$2, topicAndPartition$1, currState$1));
                        this.partitionState().put(topicAndPartition$1, OfflinePartition$.MODULE$);
                        return;
                    } else {
                        NonExistentPartition$ nonExistentPartition$ = NonExistentPartition$.MODULE$;
                        PartitionState partitionState9 = partitionState;
                        if (nonExistentPartition$ != null ? !nonExistentPartition$.equals(partitionState9) : partitionState9 != null) throw new MatchError(partitionState);
                        this.assertValidPreviousStates(topicAndPartition$1, (Seq<PartitionState>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new OfflinePartition$[]{OfflinePartition$.MODULE$})), NonExistentPartition$.MODULE$);
                        this.stateChangeLogger().trace((Function0<String>)new $anonfun$kafka$controller$PartitionStateMachine$$handleStateChange$4(this, targetState$2, topicAndPartition$1, currState$1));
                        this.partitionState().put(topicAndPartition$1, NonExistentPartition$.MODULE$);
                    }
                }
            }
            return;
        }
        catch (Throwable throwable) {
            this.stateChangeLogger().error((Function0<String>)new $anonfun$kafka$controller$PartitionStateMachine$$handleStateChange$5(this, targetState$2, topicAndPartition$1, currState$1), (Function0<Throwable>)new $anonfun$kafka$controller$PartitionStateMachine$$handleStateChange$6(this, throwable));
        }
    }

    private void initializePartitionState() {
        this.kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().foreach(new $anonfun$initializePartitionState$1(this));
    }

    private void assertValidPreviousStates(TopicAndPartition topicAndPartition, Seq<PartitionState> fromStates, PartitionState targetState) {
        if (fromStates.contains(this.partitionState().apply(topicAndPartition))) {
            return;
        }
        throw new IllegalStateException(new StringBuilder().append((Object)Predef$.MODULE$.augmentString("Partition %s should be in the %s states before moving to %s state").format((Seq<Object>)Predef$.MODULE$.genericWrapArray(new Object[]{topicAndPartition, fromStates.mkString(","), targetState}))).append((Object)Predef$.MODULE$.augmentString(". Instead it is in %s state").format((Seq<Object>)Predef$.MODULE$.genericWrapArray(new Object[]{this.partitionState().apply(topicAndPartition)}))).toString());
    }

    private void assignReplicasToPartitions(String topic, int partition2) {
        Seq<Integer> assignedReplicas = ZkUtils$.MODULE$.getReplicasForPartition(this.kafka$controller$PartitionStateMachine$$controllerContext().zkClient(), topic, partition2);
        this.kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().$plus$eq(Predef$.MODULE$.any2ArrowAssoc(new TopicAndPartition(topic, partition2)).$minus$greater(assignedReplicas));
    }

    private void initializeLeaderAndIsrForPartition(TopicAndPartition topicAndPartition$2) {
        Seq replicaAssignment = (Seq)this.kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().apply(topicAndPartition$2);
        Seq liveAssignedReplicas$1 = (Seq)replicaAssignment.filter(new $anonfun$1(this));
        int n = liveAssignedReplicas$1.size();
        if (n == 0) {
            String failMsg$1 = Predef$.MODULE$.augmentString("encountered error during state change of partition %s from New to Online, assigned replicas are [%s], live brokers are [%s]. No assigned replica is alive.").format((Seq<Object>)Predef$.MODULE$.genericWrapArray(new Object[]{topicAndPartition$2, replicaAssignment.mkString(","), this.kafka$controller$PartitionStateMachine$$controllerContext().liveBrokerIds()}));
            this.stateChangeLogger().error((Function0<String>)new $anonfun$initializeLeaderAndIsrForPartition$1(this, failMsg$1));
            throw new StateChangeFailedException(failMsg$1);
        }
        this.debug((Function0<String>)new $anonfun$initializeLeaderAndIsrForPartition$2(this, topicAndPartition$2, liveAssignedReplicas$1));
        int leader = BoxesRunTime.unboxToInt(liveAssignedReplicas$1.head());
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch$1 = new LeaderIsrAndControllerEpoch(new LeaderAndIsr(leader, liveAssignedReplicas$1.toList()), this.kafka$controller$PartitionStateMachine$$controller.epoch());
        this.debug((Function0<String>)new $anonfun$initializeLeaderAndIsrForPartition$3(this, topicAndPartition$2, leaderIsrAndControllerEpoch$1));
        try {
            ZkUtils$.MODULE$.createPersistentPath(this.kafka$controller$PartitionStateMachine$$controllerContext().zkClient(), ZkUtils$.MODULE$.getTopicPartitionLeaderAndIsrPath(topicAndPartition$2.topic(), topicAndPartition$2.partition()), ZkUtils$.MODULE$.leaderAndIsrZkData(leaderIsrAndControllerEpoch$1.leaderAndIsr(), this.kafka$controller$PartitionStateMachine$$controller.epoch()));
            this.kafka$controller$PartitionStateMachine$$controllerContext().partitionLeadershipInfo().put(topicAndPartition$2, leaderIsrAndControllerEpoch$1);
            this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers(liveAssignedReplicas$1, topicAndPartition$2.topic(), topicAndPartition$2.partition(), leaderIsrAndControllerEpoch$1, replicaAssignment, this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers$default$6());
            return;
        }
        catch (ZkNodeExistsException zkNodeExistsException) {
            LeaderIsrAndControllerEpoch leaderIsrAndEpoch = ZkUtils$.MODULE$.getLeaderIsrAndEpochForPartition(this.kafka$controller$PartitionStateMachine$$zkClient(), topicAndPartition$2.topic(), topicAndPartition$2.partition()).get();
            String failMsg$2 = Predef$.MODULE$.augmentString("encountered error while changing partition %s's state from New to Online since LeaderAndIsr path already exists with value %s and controller epoch %d").format((Seq<Object>)Predef$.MODULE$.genericWrapArray(new Object[]{topicAndPartition$2, leaderIsrAndEpoch.leaderAndIsr().toString(), BoxesRunTime.boxToInteger(leaderIsrAndEpoch.controllerEpoch())}));
            this.stateChangeLogger().error((Function0<String>)new $anonfun$initializeLeaderAndIsrForPartition$4(this, failMsg$2));
            throw new StateChangeFailedException(failMsg$2);
        }
    }

    public void electLeaderForPartition(String topic, int partition2, PartitionLeaderSelector leaderSelector) {
        TopicAndPartition topicAndPartition$3 = new TopicAndPartition(topic, partition2);
        this.stateChangeLogger().trace((Function0<String>)new $anonfun$electLeaderForPartition$1(this, topicAndPartition$3));
        try {
            Seq<Integer> replicasForThisPartition;
            ObjectRef newLeaderAndIsr$1;
            block6: {
                Tuple2<LeaderAndIsr, Seq<Integer>> tuple2;
                block7: {
                    Tuple2<Boolean, Integer> tuple22;
                    boolean zookeeperPathUpdateSucceeded = false;
                    newLeaderAndIsr$1 = new ObjectRef(null);
                    replicasForThisPartition = (Seq<Integer>)Seq$.MODULE$.empty();
                    while (true) {
                        if (zookeeperPathUpdateSucceeded) break block6;
                        LeaderIsrAndControllerEpoch currentLeaderIsrAndEpoch = this.getLeaderIsrAndEpochOrThrowException(topic, partition2);
                        LeaderAndIsr currentLeaderAndIsr = currentLeaderIsrAndEpoch.leaderAndIsr();
                        int controllerEpoch = currentLeaderIsrAndEpoch.controllerEpoch();
                        if (controllerEpoch > this.kafka$controller$PartitionStateMachine$$controller.epoch()) {
                            String failMsg$3 = Predef$.MODULE$.augmentString("aborted leader election for partition [%s,%d] since the LeaderAndIsr path was already written by another controller. This probably means that the current controller %d went through a soft failure and another controller was elected with epoch %d.").format((Seq<Object>)Predef$.MODULE$.genericWrapArray(new Object[]{topic, BoxesRunTime.boxToInteger(partition2), BoxesRunTime.boxToInteger(this.kafka$controller$PartitionStateMachine$$controllerId()), BoxesRunTime.boxToInteger(controllerEpoch)}));
                            this.stateChangeLogger().error((Function0<String>)new $anonfun$electLeaderForPartition$2(this, failMsg$3));
                            throw new StateChangeFailedException(failMsg$3);
                        }
                        tuple2 = leaderSelector.selectLeader(topicAndPartition$3, currentLeaderAndIsr);
                        if (tuple2 == null) break block7;
                        Tuple2<LeaderAndIsr, Seq<Integer>> tuple23 = new Tuple2<LeaderAndIsr, Seq<Integer>>(tuple2._1(), tuple2._2());
                        LeaderAndIsr leaderAndIsr = tuple23._1();
                        Seq<Integer> replicas = tuple23._2();
                        tuple22 = ZkUtils$.MODULE$.conditionalUpdatePersistentPath(this.kafka$controller$PartitionStateMachine$$zkClient(), ZkUtils$.MODULE$.getTopicPartitionLeaderAndIsrPath(topic, partition2), ZkUtils$.MODULE$.leaderAndIsrZkData(leaderAndIsr, this.kafka$controller$PartitionStateMachine$$controller.epoch()), currentLeaderAndIsr.zkVersion());
                        if (tuple22 == null) break;
                        Tuple2<Boolean, Integer> tuple24 = new Tuple2<Boolean, Integer>(tuple22._1(), tuple22._2());
                        boolean updateSucceeded = BoxesRunTime.unboxToBoolean(tuple24._1());
                        int newVersion = tuple24._2$mcI$sp();
                        newLeaderAndIsr$1.elem = leaderAndIsr;
                        ((LeaderAndIsr)newLeaderAndIsr$1.elem).zkVersion_$eq(newVersion);
                        zookeeperPathUpdateSucceeded = updateSucceeded;
                        replicasForThisPartition = replicas;
                    }
                    throw new MatchError(tuple22);
                }
                throw new MatchError(tuple2);
            }
            LeaderIsrAndControllerEpoch newLeaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch((LeaderAndIsr)newLeaderAndIsr$1.elem, this.kafka$controller$PartitionStateMachine$$controller.epoch());
            this.kafka$controller$PartitionStateMachine$$controllerContext().partitionLeadershipInfo().put(new TopicAndPartition(topic, partition2), newLeaderIsrAndControllerEpoch);
            this.stateChangeLogger().trace((Function0<String>)new $anonfun$electLeaderForPartition$3(this, topicAndPartition$3, newLeaderAndIsr$1));
            Seq replicas = (Seq)this.kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().apply(new TopicAndPartition(topic, partition2));
            this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers(replicasForThisPartition, topic, partition2, newLeaderIsrAndControllerEpoch, replicas, this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers$default$6());
        }
        catch (Throwable throwable) {
            String failMsg$4 = Predef$.MODULE$.augmentString("encountered error while electing leader for partition %s due to: %s.").format((Seq<Object>)Predef$.MODULE$.genericWrapArray(new Object[]{topicAndPartition$3, throwable.getMessage()}));
            this.stateChangeLogger().error((Function0<String>)new $anonfun$electLeaderForPartition$4(this, failMsg$4));
            throw new StateChangeFailedException(failMsg$4, throwable);
        }
        catch (NoReplicaOnlineException noReplicaOnlineException) {
            throw noReplicaOnlineException;
        }
        catch (LeaderElectionNotNeededException leaderElectionNotNeededException) {
            // empty catch block
        }
        this.debug((Function0<String>)new $anonfun$electLeaderForPartition$5(this));
    }

    private List<String> registerTopicChangeListener() {
        this.topicChangeListener_$eq(new TopicChangeListener());
        return this.kafka$controller$PartitionStateMachine$$zkClient().subscribeChildChanges(ZkUtils$.MODULE$.BrokerTopicsPath(), this.topicChangeListener());
    }

    public void registerPartitionChangeListener(String topic) {
        this.addPartitionsListener().put(topic, new AddPartitionsListener(this, topic));
        this.kafka$controller$PartitionStateMachine$$zkClient().subscribeDataChanges(ZkUtils$.MODULE$.getTopicPath(topic), (IZkDataListener)this.addPartitionsListener().apply(topic));
    }

    public void deregisterPartitionChangeListener(String topic) {
        this.kafka$controller$PartitionStateMachine$$zkClient().unsubscribeDataChanges(ZkUtils$.MODULE$.getTopicPath(topic), (IZkDataListener)this.addPartitionsListener().apply(topic));
    }

    private List<String> registerDeleteTopicListener() {
        this.deleteTopicsListener_$eq(new DeleteTopicsListener());
        return this.kafka$controller$PartitionStateMachine$$zkClient().subscribeChildChanges(ZkUtils$.MODULE$.DeleteTopicsPath(), this.deleteTopicsListener());
    }

    private LeaderIsrAndControllerEpoch getLeaderIsrAndEpochOrThrowException(String topic, int partition2) {
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partition2);
        Option<LeaderIsrAndControllerEpoch> option = ZkUtils$.MODULE$.getLeaderIsrAndEpochForPartition(this.kafka$controller$PartitionStateMachine$$zkClient(), topic, partition2);
        if (option instanceof Some) {
            return (LeaderIsrAndControllerEpoch)((Some)option).x();
        }
        None$ none$ = None$.MODULE$;
        Option<LeaderIsrAndControllerEpoch> option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            String failMsg = Predef$.MODULE$.augmentString("LeaderAndIsr information doesn't exist for partition %s in %s state").format((Seq<Object>)Predef$.MODULE$.genericWrapArray(new Object[]{topicAndPartition, this.partitionState().apply(topicAndPartition)}));
            throw new StateChangeFailedException(failMsg);
        }
        throw new MatchError(option);
    }

    public PartitionStateMachine(KafkaController controller) {
        this.kafka$controller$PartitionStateMachine$$controller = controller;
        Logging$class.$init$(this);
        this.kafka$controller$PartitionStateMachine$$controllerContext = controller.controllerContext();
        this.kafka$controller$PartitionStateMachine$$controllerId = controller.config().brokerId();
        this.kafka$controller$PartitionStateMachine$$zkClient = this.kafka$controller$PartitionStateMachine$$controllerContext().zkClient();
        this.partitionState = Map$.MODULE$.empty();
        this.brokerRequestBatch = new ControllerBrokerRequestBatch(controller);
        this.kafka$controller$PartitionStateMachine$$hasStarted = new AtomicBoolean(false);
        this.noOpPartitionLeaderSelector = new NoOpLeaderSelector(this.kafka$controller$PartitionStateMachine$$controllerContext());
        this.logIdent_$eq(new StringBuilder().append((Object)"[Partition state machine on Controller ").append(BoxesRunTime.boxToInteger(this.kafka$controller$PartitionStateMachine$$controllerId())).append((Object)"]: ").toString());
        this.stateChangeLogger = KafkaController$.MODULE$.stateChangeLogger();
        this.topicChangeListener = null;
        this.deleteTopicsListener = null;
        this.addPartitionsListener = Map$.MODULE$.empty();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     * Duplicate member names - consider using --renamedupmembers true
     */
    public class TopicChangeListener
    implements IZkChildListener,
    Logging,
    ScalaObject {
        private final String loggerName;
        private final Logger logger;
        private String logIdent;
        private final Log4jController$ kafka$utils$Logging$$log4jController;
        public volatile int bitmap$0;

        @Override
        public String loggerName() {
            return this.loggerName;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Logger logger() {
            if ((this.bitmap$0 & 1) != 0) return this.logger;
            TopicChangeListener topicChangeListener = this;
            synchronized (topicChangeListener) {
                if ((this.bitmap$0 & 1) == 0) {
                    this.logger = Logging$class.logger(this);
                    this.bitmap$0 |= 1;
                }
                return this.logger;
            }
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String string2) {
            this.logIdent = string2;
        }

        @Override
        public final Log4jController$ kafka$utils$Logging$$log4jController() {
            return this.kafka$utils$Logging$$log4jController;
        }

        @Override
        public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
            this.loggerName = string2;
        }

        @Override
        public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
            this.kafka$utils$Logging$$log4jController = log4jController$;
        }

        public void trace(Function0 msg) {
            Logging$class.trace(this, msg);
        }

        public Object trace(Function0 e) {
            return Logging$class.trace(this, e);
        }

        public void trace(Function0 msg, Function0 e) {
            Logging$class.trace(this, msg, e);
        }

        public void swallowTrace(Function0 action) {
            Logging$class.swallowTrace(this, action);
        }

        public void debug(Function0 msg) {
            Logging$class.debug(this, msg);
        }

        public Object debug(Function0 e) {
            return Logging$class.debug(this, e);
        }

        public void debug(Function0 msg, Function0 e) {
            Logging$class.debug(this, msg, e);
        }

        public void swallowDebug(Function0 action) {
            Logging$class.swallowDebug(this, action);
        }

        public void info(Function0 msg) {
            Logging$class.info(this, msg);
        }

        public Object info(Function0 e) {
            return Logging$class.info(this, e);
        }

        public void info(Function0 msg, Function0 e) {
            Logging$class.info(this, msg, e);
        }

        public void swallowInfo(Function0 action) {
            Logging$class.swallowInfo(this, action);
        }

        public void warn(Function0 msg) {
            Logging$class.warn(this, msg);
        }

        public Object warn(Function0 e) {
            return Logging$class.warn(this, e);
        }

        public void warn(Function0 msg, Function0 e) {
            Logging$class.warn(this, msg, e);
        }

        public void swallowWarn(Function0 action) {
            Logging$class.swallowWarn(this, action);
        }

        public void swallow(Function0 action) {
            Logging$class.swallow(this, action);
        }

        public void error(Function0 msg) {
            Logging$class.error(this, msg);
        }

        public Object error(Function0 e) {
            return Logging$class.error(this, e);
        }

        public void error(Function0 msg, Function0 e) {
            Logging$class.error(this, msg, e);
        }

        public void swallowError(Function0 action) {
            Logging$class.swallowError(this, action);
        }

        public void fatal(Function0 msg) {
            Logging$class.fatal(this, msg);
        }

        public Object fatal(Function0 e) {
            return Logging$class.fatal(this, e);
        }

        public void fatal(Function0 msg, Function0 e) {
            Logging$class.fatal(this, msg, e);
        }

        @Override
        public void handleChildChange(String parentPath$1, List<String> children$1) throws Exception {
            Utils$.MODULE$.inLock(this.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().controllerLock(), new TopicChangeListener$$anonfun$handleChildChange$1(this, parentPath$1, children$1));
        }

        public /* synthetic */ PartitionStateMachine kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer() {
            return PartitionStateMachine.this;
        }

        public TopicChangeListener() {
            if (PartitionStateMachine.this == null) {
                throw new NullPointerException();
            }
            Logging$class.$init$(this);
            this.logIdent_$eq(new StringBuilder().append((Object)"[TopicChangeListener on Controller ").append(BoxesRunTime.boxToInteger(PartitionStateMachine.this.kafka$controller$PartitionStateMachine$$controller.config().brokerId())).append((Object)"]: ").toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     * Duplicate member names - consider using --renamedupmembers true
     */
    public class DeleteTopicsListener
    implements IZkChildListener,
    Logging,
    ScalaObject {
        private final ZkClient zkClient;
        private final String loggerName;
        private final Logger logger;
        private String logIdent;
        private final Log4jController$ kafka$utils$Logging$$log4jController;
        public volatile int bitmap$0;

        @Override
        public String loggerName() {
            return this.loggerName;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Logger logger() {
            if ((this.bitmap$0 & 1) != 0) return this.logger;
            DeleteTopicsListener deleteTopicsListener = this;
            synchronized (deleteTopicsListener) {
                if ((this.bitmap$0 & 1) == 0) {
                    this.logger = Logging$class.logger(this);
                    this.bitmap$0 |= 1;
                }
                return this.logger;
            }
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String string2) {
            this.logIdent = string2;
        }

        @Override
        public final Log4jController$ kafka$utils$Logging$$log4jController() {
            return this.kafka$utils$Logging$$log4jController;
        }

        @Override
        public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
            this.loggerName = string2;
        }

        @Override
        public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
            this.kafka$utils$Logging$$log4jController = log4jController$;
        }

        public void trace(Function0 msg) {
            Logging$class.trace(this, msg);
        }

        public Object trace(Function0 e) {
            return Logging$class.trace(this, e);
        }

        public void trace(Function0 msg, Function0 e) {
            Logging$class.trace(this, msg, e);
        }

        public void swallowTrace(Function0 action) {
            Logging$class.swallowTrace(this, action);
        }

        public void debug(Function0 msg) {
            Logging$class.debug(this, msg);
        }

        public Object debug(Function0 e) {
            return Logging$class.debug(this, e);
        }

        public void debug(Function0 msg, Function0 e) {
            Logging$class.debug(this, msg, e);
        }

        public void swallowDebug(Function0 action) {
            Logging$class.swallowDebug(this, action);
        }

        public void info(Function0 msg) {
            Logging$class.info(this, msg);
        }

        public Object info(Function0 e) {
            return Logging$class.info(this, e);
        }

        public void info(Function0 msg, Function0 e) {
            Logging$class.info(this, msg, e);
        }

        public void swallowInfo(Function0 action) {
            Logging$class.swallowInfo(this, action);
        }

        public void warn(Function0 msg) {
            Logging$class.warn(this, msg);
        }

        public Object warn(Function0 e) {
            return Logging$class.warn(this, e);
        }

        public void warn(Function0 msg, Function0 e) {
            Logging$class.warn(this, msg, e);
        }

        public void swallowWarn(Function0 action) {
            Logging$class.swallowWarn(this, action);
        }

        public void swallow(Function0 action) {
            Logging$class.swallow(this, action);
        }

        public void error(Function0 msg) {
            Logging$class.error(this, msg);
        }

        public Object error(Function0 e) {
            return Logging$class.error(this, e);
        }

        public void error(Function0 msg, Function0 e) {
            Logging$class.error(this, msg, e);
        }

        public void swallowError(Function0 action) {
            Logging$class.swallowError(this, action);
        }

        public void fatal(Function0 msg) {
            Logging$class.fatal(this, msg);
        }

        public Object fatal(Function0 e) {
            return Logging$class.fatal(this, e);
        }

        public void fatal(Function0 msg, Function0 e) {
            Logging$class.fatal(this, msg, e);
        }

        public ZkClient zkClient() {
            return this.zkClient;
        }

        @Override
        public void handleChildChange(String parentPath, List<String> children$2) throws Exception {
            Utils$.MODULE$.inLock(this.kafka$controller$PartitionStateMachine$DeleteTopicsListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().controllerLock(), new DeleteTopicsListener$$anonfun$handleChildChange$2(this, children$2));
        }

        public void handleDataDeleted(String dataPath) throws Exception {
        }

        public /* synthetic */ PartitionStateMachine kafka$controller$PartitionStateMachine$DeleteTopicsListener$$$outer() {
            return PartitionStateMachine.this;
        }

        public DeleteTopicsListener() {
            if (PartitionStateMachine.this == null) {
                throw new NullPointerException();
            }
            Logging$class.$init$(this);
            this.logIdent_$eq(new StringBuilder().append((Object)"[DeleteTopicsListener on ").append(BoxesRunTime.boxToInteger(PartitionStateMachine.this.kafka$controller$PartitionStateMachine$$controller.config().brokerId())).append((Object)"]: ").toString());
            this.zkClient = PartitionStateMachine.this.kafka$controller$PartitionStateMachine$$controllerContext().zkClient();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public class AddPartitionsListener
    implements IZkDataListener,
    Logging,
    ScalaObject {
        public final String kafka$controller$PartitionStateMachine$AddPartitionsListener$$topic;
        public final /* synthetic */ PartitionStateMachine $outer;
        private final String loggerName;
        private final Logger logger;
        private String logIdent;
        private final Log4jController$ kafka$utils$Logging$$log4jController;
        public volatile int bitmap$0;

        public String loggerName() {
            return this.loggerName;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Logger logger() {
            if ((this.bitmap$0 & 1) != 0) return this.logger;
            AddPartitionsListener addPartitionsListener = this;
            synchronized (addPartitionsListener) {
                if ((this.bitmap$0 & 1) == 0) {
                    this.logger = Logging$class.logger(this);
                    this.bitmap$0 |= 1;
                }
                return this.logger;
            }
        }

        public String logIdent() {
            return this.logIdent;
        }

        public void logIdent_$eq(String string2) {
            this.logIdent = string2;
        }

        public final Log4jController$ kafka$utils$Logging$$log4jController() {
            return this.kafka$utils$Logging$$log4jController;
        }

        public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
            this.loggerName = string2;
        }

        public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
            this.kafka$utils$Logging$$log4jController = log4jController$;
        }

        public void trace(Function0 msg) {
            Logging$class.trace(this, msg);
        }

        public Object trace(Function0 e) {
            return Logging$class.trace(this, e);
        }

        public void trace(Function0 msg, Function0 e) {
            Logging$class.trace(this, msg, e);
        }

        public void swallowTrace(Function0 action) {
            Logging$class.swallowTrace(this, action);
        }

        public void debug(Function0 msg) {
            Logging$class.debug(this, msg);
        }

        public Object debug(Function0 e) {
            return Logging$class.debug(this, e);
        }

        public void debug(Function0 msg, Function0 e) {
            Logging$class.debug(this, msg, e);
        }

        public void swallowDebug(Function0 action) {
            Logging$class.swallowDebug(this, action);
        }

        public void info(Function0 msg) {
            Logging$class.info(this, msg);
        }

        public Object info(Function0 e) {
            return Logging$class.info(this, e);
        }

        public void info(Function0 msg, Function0 e) {
            Logging$class.info(this, msg, e);
        }

        public void swallowInfo(Function0 action) {
            Logging$class.swallowInfo(this, action);
        }

        public void warn(Function0 msg) {
            Logging$class.warn(this, msg);
        }

        public Object warn(Function0 e) {
            return Logging$class.warn(this, e);
        }

        public void warn(Function0 msg, Function0 e) {
            Logging$class.warn(this, msg, e);
        }

        public void swallowWarn(Function0 action) {
            Logging$class.swallowWarn(this, action);
        }

        public void swallow(Function0 action) {
            Logging$class.swallow(this, action);
        }

        public void error(Function0 msg) {
            Logging$class.error(this, msg);
        }

        public Object error(Function0 e) {
            return Logging$class.error(this, e);
        }

        public void error(Function0 msg, Function0 e) {
            Logging$class.error(this, msg, e);
        }

        public void swallowError(Function0 action) {
            Logging$class.swallowError(this, action);
        }

        public void fatal(Function0 msg) {
            Logging$class.fatal(this, msg);
        }

        public Object fatal(Function0 e) {
            return Logging$class.fatal(this, e);
        }

        public void fatal(Function0 msg, Function0 e) {
            Logging$class.fatal(this, msg, e);
        }

        public void handleDataChange(String dataPath$1, Object data$1) throws Exception {
            Utils$.MODULE$.inLock(this.kafka$controller$PartitionStateMachine$AddPartitionsListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().controllerLock(), new AddPartitionsListener$$anonfun$handleDataChange$1(this, dataPath$1, data$1));
        }

        public void handleDataDeleted(String parentPath) throws Exception {
        }

        public /* synthetic */ PartitionStateMachine kafka$controller$PartitionStateMachine$AddPartitionsListener$$$outer() {
            return this.$outer;
        }

        public AddPartitionsListener(PartitionStateMachine $outer, String topic) {
            this.kafka$controller$PartitionStateMachine$AddPartitionsListener$$topic = topic;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            Logging$class.$init$(this);
            this.logIdent_$eq(new StringBuilder().append((Object)"[AddPartitionsListener on ").append(BoxesRunTime.boxToInteger($outer.kafka$controller$PartitionStateMachine$$controller.config().brokerId())).append((Object)"]: ").toString());
        }
    }
}

