/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.ui.swing;

import com.qarks.util.ui.DialogUtilities;
import com.qarks.util.ui.resources.ResourceKey;
import com.qarks.util.ui.resources.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import java.util.SortedSet;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.jdesktop.swingx.JXMonthView;
import org.jdesktop.swingx.calendar.DateSelectionModel;

public class DateSelector
extends JPanel
implements ActionListener {
    private JButton next;
    private JButton previous;
    private JXMonthView mv;

    public DateSelector(boolean bl) {
        this.setLayout(new BorderLayout(5, 5));
        this.next = new JButton(">>");
        this.previous = new JButton("<<");
        this.next.addActionListener(this);
        this.previous.addActionListener(this);
        Date date = new Date();
        this.mv = new JXMonthView(date);
        if (bl) {
            this.mv.getSelectionModel().setSelectionMode(DateSelectionModel.SelectionMode.SINGLE_SELECTION);
        }
        JPanel jPanel = new JPanel(new GridLayout(1, 2, 5, 5));
        jPanel.add((Component)this.previous, 0);
        jPanel.add((Component)this.next, 1);
        this.add((Component)this.mv, "Center");
        this.add((Component)jPanel, "South");
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
    }

    public static Date showSelectionDateDialog(Window window) {
        final JDialog jDialog = new JDialog(window, ResourceManager.getString((Object)ResourceKey.DATE_SELECTION), Dialog.ModalityType.APPLICATION_MODAL);
        jDialog.setDefaultCloseOperation(2);
        jDialog.getContentPane().setLayout(new BorderLayout(5, 5));
        DateSelector dateSelector = new DateSelector(true);
        jDialog.getContentPane().add((Component)dateSelector, "Center");
        final JButton jButton = new JButton(ResourceManager.getString((Object)ResourceKey.OK));
        jButton.setEnabled(false);
        dateSelector.mv.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jButton.setEnabled(true);
            }
        });
        JButton jButton2 = new JButton(ResourceManager.getString((Object)ResourceKey.CANCEL));
        JPanel jPanel = new JPanel(new FlowLayout(2, 5, 5));
        jPanel.add(jButton);
        jPanel.add(jButton2);
        final Vector vector = new Vector();
        jDialog.getContentPane().add((Component)jPanel, "South");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                vector.add(new Object());
                jDialog.dispose();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
            }
        });
        jDialog.pack();
        if (window != null && window.isShowing()) {
            DialogUtilities.centerWindow(jDialog, window);
        } else {
            DialogUtilities.centerOnScreen(jDialog);
        }
        Date date = null;
        if (!vector.isEmpty()) {
            date = dateSelector.getSelectedDate();
        }
        return date;
    }

    public Date getSelectedDate() {
        Date date = null;
        SortedSet sortedSet = this.mv.getSelectionModel().getSelection();
        if (sortedSet != null && !sortedSet.isEmpty()) {
            date = (Date)sortedSet.first();
        }
        return date;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        Calendar calendar = this.mv.getCalendar();
        if (object == this.previous) {
            calendar.add(2, -1);
            Date date = calendar.getTime();
            this.mv.setFirstDisplayedDay(date);
        } else if (object == this.next) {
            calendar.add(2, 1);
            Date date = calendar.getTime();
            this.mv.setFirstDisplayedDay(date);
        }
    }
}

