/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.ui.lookandfeel;

import com.qarks.util.PreferenceManager;
import com.qarks.util.ui.DialogUtilities;
import com.qarks.util.ui.lookandfeel.LookAndFeelChooser;
import com.qarks.util.ui.resources.ResourceKey;
import com.qarks.util.ui.resources.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class LookAndFeelAction
extends AbstractAction {
    private Component component;
    private List<String> lafNames;
    private String baseDir;
    private String baseResource;
    private PreferenceManager preferenceManager;

    public LookAndFeelAction(Component component, String string, String string2, PreferenceManager preferenceManager) {
        super(ResourceManager.getString((Object)ResourceKey.LOOK_AND_FEEL));
        this.preferenceManager = preferenceManager;
        this.baseDir = string;
        this.baseResource = string2;
        this.component = component;
        this.lafNames = new ArrayList<String>();
        this.initLookAndFeels();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Window window = SwingUtilities.getWindowAncestor(this.component);
        if (window == null && this.component instanceof Window) {
            window = (Window)this.component;
        }
        LafSelectionDialog lafSelectionDialog = new LafSelectionDialog(window);
        lafSelectionDialog.setSize(300, 400);
        DialogUtilities.centerWindow(lafSelectionDialog, window);
    }

    private void initLookAndFeels() {
        File[] fileArray;
        File file = new File(this.baseDir);
        for (File file2 : fileArray = file.listFiles()) {
            if (!file2.getName().endsWith("themepack.zip")) continue;
            String string = file2.getName();
            this.lafNames.add(string);
        }
    }

    private class LafSelectionDialog
    extends JDialog
    implements ActionListener,
    ListSelectionListener {
        private JList lafList;
        private DefaultListModel lafListModel;
        private JButton ok;
        private JButton cancel;

        public LafSelectionDialog(Window window) {
            super(window, ResourceManager.getString((Object)ResourceKey.SELECT_LAF), Dialog.ModalityType.APPLICATION_MODAL);
            Container container = this.getContentPane();
            container.setLayout(new GridLayout(1, 1));
            JPanel jPanel = new JPanel(new BorderLayout(5, 5));
            jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
            container.add(jPanel);
            this.ok = new JButton(ResourceManager.getString((Object)ResourceKey.OK));
            this.ok.setEnabled(false);
            this.ok.addActionListener(this);
            this.cancel = new JButton(ResourceManager.getString((Object)ResourceKey.CANCEL));
            this.cancel.addActionListener(this);
            JPanel jPanel2 = new JPanel(new FlowLayout(2, 5, 5));
            jPanel2.add(this.ok);
            jPanel2.add(this.cancel);
            String string = LookAndFeelAction.this.preferenceManager.getProperty("qarks.googlerank.laf", "iBarthemepack.zip");
            this.lafListModel = new DefaultListModel();
            this.lafList = new JList(this.lafListModel);
            this.lafList.addListSelectionListener(this);
            for (String string2 : LookAndFeelAction.this.lafNames) {
                this.lafListModel.addElement(string2);
            }
            this.lafList.setSelectedValue(string, true);
            JPanel jPanel3 = new JPanel(new BorderLayout(5, 5));
            jPanel3.add((Component)new JScrollPane(this.lafList), "Center");
            jPanel.add((Component)jPanel3, "Center");
            jPanel.add((Component)jPanel2, "South");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.ok) {
                String string = (String)this.lafList.getSelectedValue();
                LookAndFeelAction.this.preferenceManager.setProperty("qarks.googlerank.laf", string);
                System.setProperty("skin.skinLF.name", string);
                LookAndFeelChooser.loadLookAndFeel();
                Window window = SwingUtilities.getWindowAncestor(LookAndFeelAction.this.component);
                if (window == null && LookAndFeelAction.this.component instanceof Window) {
                    window = (Window)LookAndFeelAction.this.component;
                }
                SwingUtilities.updateComponentTreeUI(window);
                this.dispose();
            } else if (object == this.cancel) {
                this.dispose();
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.ok.setEnabled(this.lafList.getSelectedValue() != null);
        }
    }
}

